/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.bolt;

import com.twitter.heron.api.bolt.IWindowedBolt;
import com.twitter.heron.api.bolt.OutputCollector;
import com.twitter.heron.api.topology.OutputFieldsDeclarer;
import com.twitter.heron.api.topology.TopologyContext;
import com.twitter.heron.api.tuple.Tuple;
import com.twitter.heron.api.windowing.EvictionPolicy;
import com.twitter.heron.api.windowing.TimestampExtractor;
import com.twitter.heron.api.windowing.TriggerPolicy;
import com.twitter.heron.api.windowing.TupleFieldTimestampExtractor;
import com.twitter.heron.api.windowing.WindowingConfigs;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;

public abstract class BaseWindowedBolt
implements IWindowedBolt {
    private static final long serialVersionUID = 5688213068448231559L;
    protected final transient WindowingConfigs windowConfiguration = new WindowingConfigs();
    protected TimestampExtractor timestampExtractor;

    protected BaseWindowedBolt() {
    }

    private BaseWindowedBolt withWindowLength(Count count) {
        if (count == null) {
            throw new IllegalArgumentException("Window length cannot be set null");
        }
        if (count.value <= 0) {
            throw new IllegalArgumentException("Window length must be positive [" + count + "]");
        }
        this.windowConfiguration.put("topology.bolts.window.length.count", count.value);
        return this;
    }

    private BaseWindowedBolt withWindowLength(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Window length cannot be set null");
        }
        if (duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("Window length must be positive [" + duration + "]");
        }
        this.windowConfiguration.put("topology.bolts.window.length.duration.ms", duration.toMillis());
        return this;
    }

    private BaseWindowedBolt withSlidingInterval(Count count) {
        if (count == null) {
            throw new IllegalArgumentException("Sliding interval cannot be set null");
        }
        if (count.value <= 0) {
            throw new IllegalArgumentException("Sliding interval must be positive [" + count + "]");
        }
        this.windowConfiguration.put("topology.bolts.window.sliding.interval.count", count.value);
        return this;
    }

    private BaseWindowedBolt withSlidingInterval(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Sliding interval cannot be set null");
        }
        if (duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("Sliding interval must be positive [" + duration + "]");
        }
        this.windowConfiguration.put("topology.bolts.window.sliding.interval.duration.ms", duration.toMillis());
        return this;
    }

    public BaseWindowedBolt withWindow(Count windowLength, Count slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Count windowLength, Duration slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Duration windowLength, Count slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Duration windowLength, Duration slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Count windowLength) {
        return this.withWindowLength(windowLength).withSlidingInterval(new Count(1));
    }

    public BaseWindowedBolt withWindow(Duration windowLength) {
        return this.withWindowLength(windowLength).withSlidingInterval(new Count(1));
    }

    public BaseWindowedBolt withTumblingWindow(Count count) {
        return this.withWindowLength(count).withSlidingInterval(count);
    }

    public BaseWindowedBolt withTumblingWindow(Duration duration) {
        return this.withWindowLength(duration).withSlidingInterval(duration);
    }

    public BaseWindowedBolt withTimestampField(String fieldName) {
        return this.withTimestampExtractor(TupleFieldTimestampExtractor.of(fieldName));
    }

    public BaseWindowedBolt withTimestampExtractor(TimestampExtractor timestampExtractor) {
        if (timestampExtractor == null) {
            throw new IllegalArgumentException("Timestamp extractor cannot be set to null");
        }
        if (this.timestampExtractor != null) {
            throw new IllegalArgumentException("Window is already configured with a timestamp extractor: " + timestampExtractor);
        }
        this.timestampExtractor = timestampExtractor;
        return this;
    }

    @Override
    public TimestampExtractor getTimestampExtractor() {
        return this.timestampExtractor;
    }

    public BaseWindowedBolt withLateTupleStream(String streamId) {
        if (streamId == null) {
            throw new IllegalArgumentException("Cannot set late tuple stream id to null");
        }
        this.windowConfiguration.put("topology.bolts.late.tuple.stream", streamId);
        return this;
    }

    public BaseWindowedBolt withLag(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Lag duration cannot be set null");
        }
        if (duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("Lag duration must be positive [" + duration + "]");
        }
        this.windowConfiguration.put("topology.bolts.tuple.timestamp.max.lag.ms", duration.toMillis());
        return this;
    }

    public BaseWindowedBolt withWatermarkInterval(Duration interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Watermark interval cannot be set null");
        }
        if (interval.isNegative() || interval.isZero()) {
            throw new IllegalArgumentException("Watermark interval must be positive [" + interval + "]");
        }
        this.windowConfiguration.put("topology.bolts.watermark.event.interval.ms", interval.toMillis());
        return this;
    }

    public BaseWindowedBolt withCustomEvictor(EvictionPolicy<Tuple, ?> evictionPolicy) {
        this.windowConfiguration.setTopologyBoltsWindowCustomEvictor(evictionPolicy);
        return this;
    }

    public BaseWindowedBolt withCustomTrigger(TriggerPolicy<Tuple, ?> triggerPolicy) {
        this.windowConfiguration.setTopologyBoltsWindowCustomTrigger(triggerPolicy);
        return this;
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.windowConfiguration;
    }

    public static class Count
    implements Serializable {
        private static final long serialVersionUID = -6420372171917099657L;
        public final int value;

        public Count(int value) {
            this.value = value;
        }

        public static Count of(int value) {
            return new Count(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Count count = (Count)o;
            return this.value == count.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "Count{value=" + this.value + '}';
        }
    }
}

