/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.metric;

import com.twitter.heron.api.metric.IMetric;
import com.twitter.heron.api.metric.MetricStatTimer;
import com.twitter.heron.api.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

public class LatencyStatAndMetric
implements IMetric<Double> {
    private final Object currentLock = new byte[0];
    private long currentLatBucket;
    private long currentCountBucket;
    private long bucketStart;
    private long exactExtraLat;
    private long exactExtraCount;
    private final int tmSize;
    private final long[] tmLatBuckets;
    private final long[] tmCountBuckets;
    private final long[] tmTime;
    private final int thSize;
    private final long[] thLatBuckets;
    private final long[] thCountBuckets;
    private final long[] thTime;
    private final int odSize;
    private final long[] odLatBuckets;
    private final long[] odCountBuckets;
    private final long[] odTime;
    private long allTimeLat;
    private long allTimeCount;
    private final TimerTask task;

    public LatencyStatAndMetric(int numBuckets) {
        this(numBuckets, -1L);
    }

    LatencyStatAndMetric(int numBuckets, long startTime) {
        int numBucketsCorrected = Math.max(numBuckets, 2);
        this.tmSize = 600000 / (numBucketsCorrected - 1);
        this.thSize = 10800000 / (numBucketsCorrected - 1);
        this.odSize = 86400000 / (numBucketsCorrected - 1);
        if (this.tmSize < 1 || this.thSize < 1 || this.odSize < 1) {
            throw new IllegalArgumentException("number of buckets is too large to be supported");
        }
        this.tmLatBuckets = new long[numBucketsCorrected];
        this.tmCountBuckets = new long[numBucketsCorrected];
        this.tmTime = new long[numBucketsCorrected];
        this.thLatBuckets = new long[numBucketsCorrected];
        this.thCountBuckets = new long[numBucketsCorrected];
        this.thTime = new long[numBucketsCorrected];
        this.odLatBuckets = new long[numBucketsCorrected];
        this.odCountBuckets = new long[numBucketsCorrected];
        this.odTime = new long[numBucketsCorrected];
        this.allTimeLat = 0L;
        this.allTimeCount = 0L;
        this.exactExtraLat = 0L;
        this.exactExtraCount = 0L;
        this.bucketStart = startTime >= 0L ? startTime : System.currentTimeMillis();
        this.currentLatBucket = 0L;
        this.currentCountBucket = 0L;
        if (startTime < 0L) {
            this.task = new Fresher();
            MetricStatTimer.timer.scheduleAtFixedRate(this.task, this.tmSize, (long)this.tmSize);
        } else {
            this.task = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(long latency) {
        Object object = this.currentLock;
        synchronized (object) {
            this.currentLatBucket += latency;
            ++this.currentCountBucket;
        }
    }

    @Override
    public synchronized Double getValueAndReset() {
        return this.getValueAndReset(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Double getValueAndReset(long now) {
        long count;
        long lat;
        Object object = this.currentLock;
        synchronized (object) {
            lat = this.currentLatBucket;
            count = this.currentCountBucket;
            this.currentLatBucket = 0L;
            this.currentCountBucket = 0L;
        }
        long timeSpent = now - this.bucketStart;
        long exactExtraCountSum = count + this.exactExtraCount;
        double ret = Utils.zeroIfNaNOrInf((double)(lat + this.exactExtraLat) / (double)exactExtraCountSum);
        this.bucketStart = now;
        this.exactExtraLat = 0L;
        this.exactExtraCount = 0L;
        this.rotateBuckets(lat, count, timeSpent);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void rotateSched(long now) {
        long count;
        long lat;
        Object object = this.currentLock;
        synchronized (object) {
            lat = this.currentLatBucket;
            count = this.currentCountBucket;
            this.currentLatBucket = 0L;
            this.currentCountBucket = 0L;
        }
        long timeSpent = now - this.bucketStart;
        this.exactExtraLat += lat;
        this.exactExtraCount += count;
        this.bucketStart = now;
        this.rotateBuckets(lat, count, timeSpent);
    }

    synchronized void rotateBuckets(long lat, long count, long timeSpent) {
        this.rotate(lat, count, timeSpent, this.tmSize, this.tmTime, this.tmLatBuckets, this.tmCountBuckets);
        this.rotate(lat, count, timeSpent, this.thSize, this.thTime, this.thLatBuckets, this.thCountBuckets);
        this.rotate(lat, count, timeSpent, this.odSize, this.odTime, this.odLatBuckets, this.odCountBuckets);
        this.allTimeLat += lat;
        this.allTimeCount += count;
    }

    private synchronized void rotate(long lat, long count, long timeSpent, long targetSize, long[] times, long[] latBuckets, long[] countBuckets) {
        times[0] = times[0] + timeSpent;
        latBuckets[0] = latBuckets[0] + lat;
        countBuckets[0] = countBuckets[0] + count;
        long currentTime = 0L;
        long currentLat = 0L;
        long currentCount = 0L;
        if (times[0] >= targetSize) {
            for (int i = 0; i < latBuckets.length; ++i) {
                long tmpTime = times[i];
                times[i] = currentTime;
                currentTime = tmpTime;
                long lt = latBuckets[i];
                latBuckets[i] = currentLat;
                currentLat = lt;
                long cnt = countBuckets[i];
                countBuckets[i] = currentCount;
                currentCount = cnt;
            }
        }
    }

    public synchronized Map<String, Double> getTimeLatAvg() {
        return this.getTimeLatAvg(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map<String, Double> getTimeLatAvg(long now) {
        long count;
        long lat;
        HashMap<String, Double> ret = new HashMap<String, Double>();
        Object object = this.currentLock;
        synchronized (object) {
            lat = this.currentLatBucket;
            count = this.currentCountBucket;
        }
        long timeSpent = now - this.bucketStart;
        ret.put("600", this.readApproximateLatAvg(lat, count, timeSpent, this.tmTime, this.tmLatBuckets, this.tmCountBuckets, 600000L));
        ret.put("10800", this.readApproximateLatAvg(lat, count, timeSpent, this.thTime, this.thLatBuckets, this.thCountBuckets, 10800000L));
        ret.put("86400", this.readApproximateLatAvg(lat, count, timeSpent, this.odTime, this.odLatBuckets, this.odCountBuckets, 86400000L));
        long allTimeCountSum = count + this.allTimeCount;
        ret.put(":all-time", Utils.zeroIfNaNOrInf((double)lat + (double)this.allTimeLat) / (double)allTimeCountSum);
        return ret;
    }

    double readApproximateLatAvg(long lat, long count, long timeSpent, long[] bucketTime, long[] latBuckets, long[] countBuckets, long desiredTime) {
        long timeNeeded = desiredTime - timeSpent;
        long totalLat = lat;
        long totalCount = count;
        for (int i = 0; i < bucketTime.length && timeNeeded > 0L; timeNeeded -= bucketTime[i], ++i) {
            totalLat += latBuckets[i];
            totalCount += countBuckets[i];
        }
        return Utils.zeroIfNaNOrInf((double)totalLat / (double)totalCount);
    }

    public void close() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    private class Fresher
    extends TimerTask {
        private Fresher() {
        }

        @Override
        public void run() {
            LatencyStatAndMetric.this.rotateSched(System.currentTimeMillis());
        }
    }
}

