/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.metric;

import com.twitter.heron.api.metric.IMetric;
import com.twitter.heron.api.metric.IReducer;

public class ReducedMetric<T, U, V>
implements IMetric<V> {
    private final IReducer<T, U, V> reducer;
    private T accumulator;

    public ReducedMetric(IReducer<T, U, V> aReducer) {
        this.reducer = aReducer;
        this.accumulator = this.reducer.init();
    }

    public void update(U value) {
        this.accumulator = this.reducer.reduce(this.accumulator, value);
    }

    @Override
    public V getValueAndReset() {
        V ret = this.reducer.extractResult(this.accumulator);
        this.accumulator = this.reducer.init();
        return ret;
    }
}

