/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.topology;

import com.twitter.heron.api.Config;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.topology.BaseConfigurationDeclarer;
import com.twitter.heron.api.topology.ComponentConfigurationDeclarer;
import com.twitter.heron.api.topology.IComponent;
import com.twitter.heron.api.utils.Utils;
import com.twitter.heron.shaded.com.google.protobuf.ByteString;
import java.util.Map;

public abstract class BaseComponentDeclarer<T extends ComponentConfigurationDeclarer<?>>
extends BaseConfigurationDeclarer<T> {
    private String name;
    private IComponent component;
    private Config componentConfiguration;

    public BaseComponentDeclarer(String name, IComponent comp, Number taskParallelism) {
        this.name = name;
        this.component = comp;
        this.componentConfiguration = comp.getComponentConfiguration() != null ? new Config(comp.getComponentConfiguration()) : new Config();
        if (taskParallelism != null) {
            Config.setComponentParallelism(this.componentConfiguration, taskParallelism.intValue());
        } else {
            Config.setComponentParallelism(this.componentConfiguration, 1);
        }
    }

    public abstract T returnThis();

    protected String getName() {
        return this.name;
    }

    @Override
    public T addConfigurations(Map<String, Object> conf) {
        this.componentConfiguration.putAll(conf);
        return this.returnThis();
    }

    public void dump(TopologyAPI.Component.Builder bldr) {
        bldr.setName(this.name);
        bldr.setSpec(TopologyAPI.ComponentObjectSpec.JAVA_SERIALIZED_OBJECT);
        bldr.setSerializedObject(ByteString.copyFrom(Utils.serialize(this.component)));
        bldr.setConfig(Utils.getConfigBuilder(this.componentConfiguration));
    }
}

