/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.topology;

import com.twitter.heron.api.bolt.IRichBolt;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.grouping.CustomStreamGrouping;
import com.twitter.heron.api.topology.BaseComponentDeclarer;
import com.twitter.heron.api.topology.OutputFieldsGetter;
import com.twitter.heron.api.tuple.Fields;
import com.twitter.heron.api.utils.Utils;
import com.twitter.heron.shaded.com.google.protobuf.ByteString;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BoltDeclarer
extends BaseComponentDeclarer<BoltDeclarer> {
    private OutputFieldsGetter output;
    private List<TopologyAPI.InputStream.Builder> inputs = new LinkedList<TopologyAPI.InputStream.Builder>();

    public BoltDeclarer(String name, IRichBolt bolt, Number taskParallelism) {
        super(name, bolt, taskParallelism);
        this.output = new OutputFieldsGetter();
        bolt.declareOutputFields(this.output);
    }

    @Override
    public BoltDeclarer returnThis() {
        return this;
    }

    public void dump(TopologyAPI.Topology.Builder bldr) {
        TopologyAPI.Bolt.Builder boltBldr = TopologyAPI.Bolt.newBuilder();
        TopologyAPI.Component.Builder cbldr = TopologyAPI.Component.newBuilder();
        super.dump(cbldr);
        boltBldr.setComp(cbldr);
        for (TopologyAPI.InputStream.Builder iter : this.inputs) {
            boltBldr.addInputs(iter);
        }
        Map<String, TopologyAPI.StreamSchema.Builder> outs = this.output.getFieldsDeclaration();
        for (Map.Entry<String, TopologyAPI.StreamSchema.Builder> entry : outs.entrySet()) {
            TopologyAPI.OutputStream.Builder obldr = TopologyAPI.OutputStream.newBuilder();
            TopologyAPI.StreamId.Builder sbldr = TopologyAPI.StreamId.newBuilder();
            sbldr.setId(entry.getKey());
            sbldr.setComponentName(this.getName());
            obldr.setStream(sbldr);
            obldr.setSchema(entry.getValue());
            boltBldr.addOutputs(obldr);
        }
        bldr.addBolts(boltBldr);
    }

    public BoltDeclarer fieldsGrouping(String componentName, Fields fields) {
        return this.fieldsGrouping(componentName, "default", fields);
    }

    public BoltDeclarer fieldsGrouping(String componentName, String streamId, Fields fields) {
        TopologyAPI.InputStream.Builder bldr = TopologyAPI.InputStream.newBuilder();
        bldr.setStream(TopologyAPI.StreamId.newBuilder().setId(streamId).setComponentName(componentName));
        bldr.setGtype(TopologyAPI.Grouping.FIELDS);
        TopologyAPI.StreamSchema.Builder gfbldr = TopologyAPI.StreamSchema.newBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            TopologyAPI.StreamSchema.KeyType.Builder ktBldr = TopologyAPI.StreamSchema.KeyType.newBuilder();
            ktBldr.setKey(fields.get(i));
            ktBldr.setType(TopologyAPI.Type.OBJECT);
            gfbldr.addKeys(ktBldr);
        }
        bldr.setGroupingFields(gfbldr);
        return this.grouping(bldr);
    }

    public BoltDeclarer globalGrouping(String componentName) {
        return this.globalGrouping(componentName, "default");
    }

    public BoltDeclarer globalGrouping(String componentName, String streamId) {
        TopologyAPI.InputStream.Builder bldr = TopologyAPI.InputStream.newBuilder();
        bldr.setStream(TopologyAPI.StreamId.newBuilder().setId(streamId).setComponentName(componentName));
        bldr.setGtype(TopologyAPI.Grouping.LOWEST);
        return this.grouping(bldr);
    }

    public BoltDeclarer shuffleGrouping(String componentName) {
        return this.shuffleGrouping(componentName, "default");
    }

    public BoltDeclarer shuffleGrouping(String componentName, String streamId) {
        TopologyAPI.InputStream.Builder bldr = TopologyAPI.InputStream.newBuilder();
        bldr.setStream(TopologyAPI.StreamId.newBuilder().setId(streamId).setComponentName(componentName));
        bldr.setGtype(TopologyAPI.Grouping.SHUFFLE);
        return this.grouping(bldr);
    }

    public BoltDeclarer localOrShuffleGrouping(String componentName) {
        return this.localOrShuffleGrouping(componentName, "default");
    }

    public BoltDeclarer localOrShuffleGrouping(String componentName, String streamId) {
        return this.shuffleGrouping(componentName, streamId);
    }

    public BoltDeclarer noneGrouping(String componentName) {
        return this.noneGrouping(componentName, "default");
    }

    public BoltDeclarer noneGrouping(String componentName, String streamId) {
        TopologyAPI.InputStream.Builder bldr = TopologyAPI.InputStream.newBuilder();
        bldr.setStream(TopologyAPI.StreamId.newBuilder().setId(streamId).setComponentName(componentName));
        bldr.setGtype(TopologyAPI.Grouping.NONE);
        return this.grouping(bldr);
    }

    public BoltDeclarer allGrouping(String componentName) {
        return this.allGrouping(componentName, "default");
    }

    public BoltDeclarer allGrouping(String componentName, String streamId) {
        TopologyAPI.InputStream.Builder bldr = TopologyAPI.InputStream.newBuilder();
        bldr.setStream(TopologyAPI.StreamId.newBuilder().setId(streamId).setComponentName(componentName));
        bldr.setGtype(TopologyAPI.Grouping.ALL);
        return this.grouping(bldr);
    }

    public BoltDeclarer directGrouping(String componentName) {
        return this.directGrouping(componentName, "default");
    }

    public BoltDeclarer directGrouping(String componentName, String streamId) {
        TopologyAPI.InputStream.Builder bldr = TopologyAPI.InputStream.newBuilder();
        bldr.setStream(TopologyAPI.StreamId.newBuilder().setId(streamId).setComponentName(componentName));
        bldr.setGtype(TopologyAPI.Grouping.DIRECT);
        bldr.setType(TopologyAPI.CustomGroupingObjectType.JAVA_OBJECT);
        return this.grouping(bldr);
    }

    public BoltDeclarer customGrouping(String componentName, CustomStreamGrouping grouping) {
        return this.customGrouping(componentName, "default", grouping);
    }

    public BoltDeclarer customGrouping(String componentName, String streamId, CustomStreamGrouping grouping) {
        TopologyAPI.InputStream.Builder bldr = TopologyAPI.InputStream.newBuilder();
        bldr.setStream(TopologyAPI.StreamId.newBuilder().setId(streamId).setComponentName(componentName));
        bldr.setGtype(TopologyAPI.Grouping.CUSTOM);
        bldr.setType(TopologyAPI.CustomGroupingObjectType.JAVA_OBJECT);
        bldr.setCustomGroupingObject(ByteString.copyFrom(Utils.serialize(grouping)));
        return this.grouping(bldr);
    }

    private BoltDeclarer grouping(TopologyAPI.InputStream.Builder stream) {
        this.inputs.add(stream);
        return this;
    }
}

