/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.topology;

import com.twitter.heron.api.HeronTopology;
import com.twitter.heron.api.bolt.BasicBoltExecutor;
import com.twitter.heron.api.bolt.IBasicBolt;
import com.twitter.heron.api.bolt.IRichBolt;
import com.twitter.heron.api.bolt.IStatefulWindowedBolt;
import com.twitter.heron.api.bolt.IWindowedBolt;
import com.twitter.heron.api.bolt.StatefulWindowedBoltExecutor;
import com.twitter.heron.api.bolt.WindowedBoltExecutor;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.spout.IRichSpout;
import com.twitter.heron.api.topology.BaseComponentDeclarer;
import com.twitter.heron.api.topology.BoltDeclarer;
import com.twitter.heron.api.topology.SpoutDeclarer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TopologyBuilder {
    private Map<String, BoltDeclarer> bolts = new HashMap<String, BoltDeclarer>();
    private Map<String, SpoutDeclarer> spouts = new HashMap<String, SpoutDeclarer>();

    public HeronTopology createTopology() {
        TopologyAPI.Topology.Builder bldr = TopologyAPI.Topology.newBuilder();
        for (Map.Entry<String, SpoutDeclarer> entry : this.spouts.entrySet()) {
            entry.getValue().dump(bldr);
        }
        for (Map.Entry<String, BaseComponentDeclarer> entry : this.bolts.entrySet()) {
            ((BoltDeclarer)entry.getValue()).dump(bldr);
        }
        return new HeronTopology(bldr);
    }

    public BoltDeclarer setBolt(String id, IRichBolt bolt) {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IRichBolt bolt, Number parallelismHint) {
        this.validateComponentName(id);
        BoltDeclarer b = new BoltDeclarer(id, bolt, parallelismHint);
        this.bolts.put(id, b);
        return b;
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt) {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IBasicBolt bolt, Number parallelismHint) {
        return this.setBolt(id, new BasicBoltExecutor(bolt), parallelismHint);
    }

    public BoltDeclarer setBolt(String id, IWindowedBolt bolt) throws IllegalArgumentException {
        return this.setBolt(id, bolt, null);
    }

    public BoltDeclarer setBolt(String id, IWindowedBolt bolt, Number parallelismHint) throws IllegalArgumentException {
        return this.setBolt(id, new WindowedBoltExecutor(bolt), parallelismHint);
    }

    public <K extends Serializable, V extends Serializable> BoltDeclarer setBolt(String id, IStatefulWindowedBolt<K, V> bolt) throws IllegalArgumentException {
        return this.setBolt(id, bolt, null);
    }

    public <K extends Serializable, V extends Serializable> BoltDeclarer setBolt(String id, IStatefulWindowedBolt<K, V> bolt, Number parallelismHint) throws IllegalArgumentException {
        return this.setBolt(id, new StatefulWindowedBoltExecutor(bolt), parallelismHint);
    }

    public SpoutDeclarer setSpout(String id, IRichSpout spout) {
        return this.setSpout(id, spout, null);
    }

    public SpoutDeclarer setSpout(String id, IRichSpout spout, Number parallelismHint) {
        this.validateComponentName(id);
        SpoutDeclarer s = new SpoutDeclarer(id, spout, parallelismHint);
        this.spouts.put(id, s);
        return s;
    }

    private void validateComponentName(String name) {
        if (name.contains(",")) {
            throw new IllegalArgumentException("Component name should not contain comma(,)");
        }
        if (name.contains(":")) {
            throw new IllegalArgumentException("Component name should not contain colon(:)");
        }
        this.validateUnusedName(name);
    }

    private void validateUnusedName(String name) {
        if (this.bolts.containsKey(name)) {
            throw new IllegalArgumentException("Bolt has already been declared for name " + name);
        }
        if (this.spouts.containsKey(name)) {
            throw new IllegalArgumentException("Spout has already been declared for name " + name);
        }
    }
}

