/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.tuple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Fields
implements Iterable<String>,
Serializable {
    private static final long serialVersionUID = -1045737418722082345L;
    private List<String> fields;
    private Map<String, Integer> mIndex = new HashMap<String, Integer>();

    public Fields(String ... pFields) {
        this(Arrays.asList(pFields));
    }

    public Fields(List<String> pFields) {
        this.fields = new ArrayList<String>(pFields.size());
        for (String field : pFields) {
            if (this.fields.contains(field)) {
                throw new IllegalArgumentException(String.format("duplicate field '%s'", field));
            }
            this.fields.add(field);
        }
        this.index();
    }

    public List<Object> select(Fields selector, List<Object> tuple) {
        ArrayList<Object> ret = new ArrayList<Object>(selector.size());
        for (String s : selector) {
            ret.add(tuple.get(this.mIndex.get(s)));
        }
        return ret;
    }

    public List<String> toList() {
        return new ArrayList<String>(this.fields);
    }

    public int size() {
        return this.fields.size();
    }

    public String get(int index) {
        return this.fields.get(index);
    }

    @Override
    public Iterator<String> iterator() {
        return this.fields.iterator();
    }

    public int fieldIndex(String field) {
        Integer ret = this.mIndex.get(field);
        if (ret == null) {
            throw new IllegalArgumentException(field + " does not exist");
        }
        return ret;
    }

    public boolean contains(String field) {
        return this.mIndex.containsKey(field);
    }

    private void index() {
        for (int i = 0; i < this.fields.size(); ++i) {
            this.mIndex.put(this.fields.get(i), i);
        }
    }

    public String toString() {
        return this.fields.toString();
    }
}

