/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.utils;

import com.twitter.heron.api.Config;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.shaded.com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    public static final String DEFAULT_STREAM_ID = "default";

    private Utils() {
    }

    public static List<Object> tuple(Object ... values) {
        ArrayList<Object> ret = new ArrayList<Object>();
        Collections.addAll(ret, values);
        return ret;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> readCommandLineOpts() {
        HashMap<String, String> ret = new HashMap<String, String>();
        String commandOptions = System.getenv("HERON_OPTIONS");
        if (commandOptions != null) {
            String[] configs;
            commandOptions = commandOptions.replaceAll("%%%%", " ");
            for (String config : configs = commandOptions.split(",")) {
                String[] options = config.split("=");
                if (options.length != 2) continue;
                ret.put(options[0], options[1]);
            }
        }
        return ret;
    }

    public static byte[] serialize(Object obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Object deserialize(byte[] serialized) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object ret = ois.readObject();
            ois.close();
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        buffer.get(ret, 0, ret.length);
        return ret;
    }

    public static <S, T> T get(Map<S, T> m, S key, T defaultValue) {
        T ret = m.get(key);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static TopologyAPI.Config.Builder getConfigBuilder(Config config) {
        TopologyAPI.Config.Builder cBldr = TopologyAPI.Config.newBuilder();
        Set<String> apiVars = config.getApiVars();
        for (String key : config.keySet()) {
            if (key == null) {
                LOG.warning("ignore: null config key found");
                continue;
            }
            Object value = config.get(key);
            if (value == null) {
                LOG.warning("ignore: config key " + key + " has null value");
                continue;
            }
            TopologyAPI.Config.KeyValue.Builder b = TopologyAPI.Config.KeyValue.newBuilder();
            b.setKey(key);
            if (apiVars.contains(key)) {
                b.setType(TopologyAPI.ConfigValueType.STRING_VALUE);
                b.setValue(value.toString());
            } else {
                b.setType(TopologyAPI.ConfigValueType.JAVA_SERIALIZED_VALUE);
                b.setSerializedValue(ByteString.copyFrom(Utils.serialize(value)));
            }
            cBldr.addKvs(b);
        }
        return cBldr;
    }

    public static double zeroIfNaNOrInf(double x) {
        return Double.isNaN(x) || Double.isInfinite(x) ? 0.0 : x;
    }
}

