/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.windowing;

import com.twitter.heron.api.Config;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.windowing.WaterMarkEvent;
import com.twitter.heron.api.windowing.WindowManager;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WaterMarkEventGenerator<T extends Serializable> {
    private final Map<TopologyAPI.StreamId, Long> streamToTs = new ConcurrentHashMap<TopologyAPI.StreamId, Long>();
    private final WindowManager<T> windowManager;
    private long watermarkIntervalMs;
    private final int eventTsLag;
    private final Set<TopologyAPI.StreamId> inputStreams;
    private Map<String, Object> topoConf;
    private volatile long lastWaterMarkTs;

    public WaterMarkEventGenerator(WindowManager<T> windowManager, long watermarkIntervalMs, int eventTsLagMs, Set<TopologyAPI.StreamId> inputStreams, Map<String, Object> topoConf) {
        this.windowManager = windowManager;
        this.watermarkIntervalMs = watermarkIntervalMs;
        this.eventTsLag = eventTsLagMs;
        this.inputStreams = inputStreams;
        this.topoConf = topoConf;
    }

    public boolean track(TopologyAPI.StreamId stream, long ts) {
        Long currentVal = this.streamToTs.get(stream);
        if (currentVal == null || ts > currentVal) {
            this.streamToTs.put(stream, ts);
        }
        return ts >= this.lastWaterMarkTs;
    }

    public void run() {
        long waterMarkTs = this.computeWaterMarkTs();
        if (waterMarkTs > this.lastWaterMarkTs) {
            this.windowManager.add(new WaterMarkEvent(waterMarkTs));
            this.lastWaterMarkTs = waterMarkTs;
        }
    }

    private long computeWaterMarkTs() {
        long ts = 0L;
        if (this.streamToTs.size() >= this.inputStreams.size()) {
            ts = Long.MAX_VALUE;
            for (Map.Entry<TopologyAPI.StreamId, Long> entry : this.streamToTs.entrySet()) {
                ts = Math.min(ts, entry.getValue());
            }
        }
        return ts - (long)this.eventTsLag;
    }

    public void start() {
        Config.registerTopologyTimerEvents(this.topoConf, "WaterMarkEventGeneratorTimer", Duration.ofMillis(this.watermarkIntervalMs), () -> this.run());
    }
}

