/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.windowing.evictors;

import com.twitter.heron.api.windowing.Event;
import com.twitter.heron.api.windowing.EvictionContext;
import com.twitter.heron.api.windowing.EvictionPolicy;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class CountEvictionPolicy<T extends Serializable>
implements EvictionPolicy<T, Long> {
    protected final int threshold;
    protected final AtomicLong currentCount;
    private EvictionContext context;

    public CountEvictionPolicy(int count) {
        this.threshold = count;
        this.currentCount = new AtomicLong();
    }

    @Override
    public EvictionPolicy.Action evict(Event<T> event) {
        long curVal;
        while ((curVal = this.currentCount.get()) > (long)this.threshold) {
            if (!this.currentCount.compareAndSet(curVal, curVal - 1L)) continue;
            return EvictionPolicy.Action.EXPIRE;
        }
        return EvictionPolicy.Action.PROCESS;
    }

    @Override
    public void track(Event<T> event) {
        if (!event.isWatermark()) {
            this.currentCount.incrementAndGet();
        }
    }

    @Override
    public void setContext(EvictionContext context) {
        this.context = context;
    }

    @Override
    public EvictionContext getContext() {
        return this.context;
    }

    public String toString() {
        return "CountEvictionPolicy{threshold=" + this.threshold + ", currentCount=" + this.currentCount + '}';
    }

    @Override
    public void reset() {
    }

    @Override
    public Long getState() {
        return this.currentCount.get();
    }

    @Override
    public void restoreState(Long state) {
        this.currentCount.set(state);
    }
}

