/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.basics;

public final class ByteAmount
implements Comparable<ByteAmount> {
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long MAX_MB = Math.round(8.796093E12f);
    private static final long MAX_GB = Math.round(8.589935E9f);
    public static final ByteAmount ZERO = ByteAmount.fromBytes(0L);
    private final long bytes;

    private ByteAmount(long bytes) {
        this.bytes = bytes;
    }

    public static ByteAmount fromBytes(long bytes) {
        return new ByteAmount(bytes);
    }

    public static ByteAmount fromMegabytes(long megabytes) {
        if (megabytes >= MAX_MB) {
            return new ByteAmount(Long.MAX_VALUE);
        }
        return new ByteAmount(megabytes * 0x100000L);
    }

    public static ByteAmount fromGigabytes(long gigabytes) {
        if (gigabytes >= MAX_GB) {
            return new ByteAmount(Long.MAX_VALUE);
        }
        return new ByteAmount(gigabytes * 0x40000000L);
    }

    public long asBytes() {
        return this.bytes;
    }

    public long asMegabytes() {
        return Math.round((double)this.bytes / 1048576.0);
    }

    public long asGigabytes() {
        return Math.round((double)this.bytes / 1.073741824E9);
    }

    public boolean isZero() {
        return ZERO.equals(this);
    }

    public ByteAmount minus(ByteAmount other) {
        this.checkArgument(Long.MIN_VALUE + other.asBytes() <= this.asBytes(), String.format("Subtracting %s from %s would overshoot Long.MIN_LONG", other, this));
        return ByteAmount.fromBytes(this.asBytes() - other.asBytes());
    }

    public ByteAmount plus(ByteAmount other) {
        this.checkArgument(Long.MAX_VALUE - this.asBytes() >= other.asBytes(), String.format("Adding %s to %s would exceed Long.MAX_LONG", other, this));
        return ByteAmount.fromBytes(this.asBytes() + other.asBytes());
    }

    public ByteAmount multiply(int factor) {
        this.checkArgument(this.asBytes() <= Long.MAX_VALUE / (long)factor, String.format("Multiplying %s by %d would exceed Long.MAX_LONG", this, factor));
        return ByteAmount.fromBytes(this.asBytes() * (long)factor);
    }

    public ByteAmount divide(int factor) {
        this.checkArgument(factor != 0, String.format("Can not divide %s by 0", this));
        return ByteAmount.fromBytes(Math.round((double)this.asBytes() / (double)factor));
    }

    public ByteAmount increaseBy(int percentage) {
        this.checkArgument(percentage >= 0, String.format("Increasing by negative percent (%d) not supported", percentage));
        double factor = 1.0 + (double)percentage / 100.0;
        long max = Math.round(9.223372036854776E18 / factor);
        this.checkArgument(this.asBytes() <= max, String.format("Increasing %s by %d percent would exceed Long.MAX_LONG", this, percentage));
        return ByteAmount.fromBytes(Math.round((double)this.asBytes() * factor));
    }

    public boolean greaterThan(ByteAmount other) {
        return this.asBytes() > other.asBytes();
    }

    public boolean greaterOrEqual(ByteAmount other) {
        return this.asBytes() >= other.asBytes();
    }

    public boolean lessThan(ByteAmount other) {
        return this.asBytes() < other.asBytes();
    }

    public boolean lessOrEqual(ByteAmount other) {
        return this.asBytes() <= other.asBytes();
    }

    public ByteAmount max(ByteAmount other) {
        if (this.greaterThan(other)) {
            return this;
        }
        return other;
    }

    @Override
    public int compareTo(ByteAmount other) {
        return Long.compare(this.asBytes(), other.asBytes());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ByteAmount that = (ByteAmount)other;
        return this.bytes == that.bytes;
    }

    public int hashCode() {
        return (int)(this.bytes ^ this.bytes >>> 32);
    }

    public String toString() {
        String value = this.asGigabytes() > 0L ? String.format("%d GB (%d bytes)", this.asGigabytes(), this.asBytes()) : (this.asMegabytes() > 0L ? String.format("%d MB (%d bytes)", this.asMegabytes(), this.asBytes()) : this.bytes + " bytes");
        return String.format("ByteAmount{%s}", value);
    }

    private void checkArgument(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

