/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.basics;

import com.twitter.heron.common.basics.WakeableLooper;
import java.util.Collection;
import java.util.concurrent.LinkedTransferQueue;

public class Communicator<E> {
    private final LinkedTransferQueue<E> buffer;
    private volatile WakeableLooper producer;
    private volatile WakeableLooper consumer;
    private volatile int capacity;
    private volatile int expectedAvailableCapacity;
    private volatile int expectedQueueSize;
    private volatile int averageSize;
    private volatile double currentSampleWeight;
    private volatile boolean isExpectNoMoreItems;

    public Communicator(WakeableLooper producer, WakeableLooper consumer) {
        this.producer = producer;
        this.consumer = consumer;
        this.buffer = new LinkedTransferQueue();
    }

    public Communicator() {
        this.isExpectNoMoreItems = false;
        this.producer = null;
        this.consumer = null;
        this.buffer = new LinkedTransferQueue();
    }

    public void setProducer(WakeableLooper producer) {
        this.producer = producer;
    }

    public void setConsumer(WakeableLooper consumer) {
        this.consumer = consumer;
    }

    public void init(int ipcapacity, int ipexpectedQueueSize, double ipcurrentSampleWeight) {
        this.capacity = ipcapacity;
        this.expectedQueueSize = ipexpectedQueueSize;
        this.currentSampleWeight = ipcurrentSampleWeight;
        this.expectedAvailableCapacity = this.capacity / 2;
        this.informConsumer();
        this.informProducer();
    }

    public int size() {
        return this.buffer.size();
    }

    public int remainingCapacity() {
        return this.capacity - this.size();
    }

    public E poll() {
        E result = this.buffer.poll();
        if (this.producer != null) {
            this.producer.wakeUp();
        }
        return result;
    }

    public boolean offer(E e) {
        this.buffer.offer(e);
        if (this.consumer != null) {
            this.consumer.wakeUp();
        }
        return true;
    }

    public E peek() {
        return this.buffer.peek();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public void clear() {
        this.buffer.clear();
    }

    public int drainTo(Collection<? super E> c) {
        int result = this.buffer.drainTo(c);
        if (this.producer != null) {
            this.producer.wakeUp();
        }
        return result;
    }

    public int drainTo(Collection<? super E> c, int maxElements) {
        int result = this.buffer.drainTo(c, maxElements);
        if (this.producer != null) {
            this.producer.wakeUp();
        }
        return result;
    }

    public void updateExpectedAvailableCapacity() {
        int inAvgSize = (int)((1.0 - this.currentSampleWeight) * (double)this.averageSize + this.currentSampleWeight * (double)this.size());
        int availableCapacity = this.expectedAvailableCapacity;
        if (inAvgSize < this.expectedQueueSize && availableCapacity < this.capacity) {
            this.expectedAvailableCapacity = availableCapacity + 1;
        }
        if (inAvgSize > this.expectedQueueSize && availableCapacity > 1) {
            this.expectedAvailableCapacity = availableCapacity / 2;
        }
        this.averageSize = inAvgSize;
    }

    public int getExpectedAvailableCapacity() {
        return this.isExpectNoMoreItems ? -1 : this.expectedAvailableCapacity;
    }

    public void expectNoMoreItems() {
        this.isExpectNoMoreItems = true;
        this.informProducer();
    }

    public void expectMoreItems() {
        this.isExpectNoMoreItems = false;
        this.informProducer();
    }

    public void informProducer() {
        if (this.producer != null) {
            this.producer.wakeUp();
        }
    }

    public void informConsumer() {
        if (this.consumer != null) {
            this.consumer.wakeUp();
        }
    }
}

