/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.basics;

import java.io.IOException;
import java.net.ServerSocket;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SysUtils {
    private static final Logger LOG = Logger.getLogger(SysUtils.class.getName());

    private SysUtils() {
    }

    public static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFreePort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    public static void closeIgnoringExceptions(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, String.format("Failed to close %s", closeable), e);
            }
        }
    }
}

