/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.streamlet.impl;

import com.twitter.heron.api.topology.TopologyBuilder;
import com.twitter.heron.streamlet.Builder;
import com.twitter.heron.streamlet.SerializableSupplier;
import com.twitter.heron.streamlet.Source;
import com.twitter.heron.streamlet.Streamlet;
import com.twitter.heron.streamlet.impl.StreamletImpl;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class BuilderImpl
implements Builder {
    private List<StreamletImpl<?>> sources = new LinkedList();

    @Override
    public <R> Streamlet<R> newSource(SerializableSupplier<R> supplier) {
        StreamletImpl<R> retval = StreamletImpl.createSupplierStreamlet(supplier);
        retval.setNumPartitions(1);
        this.sources.add(retval);
        return retval;
    }

    @Override
    public <R> Streamlet<R> newSource(Source<R> generator) {
        StreamletImpl<R> retval = StreamletImpl.createGeneratorStreamlet(generator);
        retval.setNumPartitions(1);
        this.sources.add(retval);
        return retval;
    }

    public TopologyBuilder build() {
        TopologyBuilder builder = new TopologyBuilder();
        HashSet<String> stageNames = new HashSet<String>();
        for (StreamletImpl<?> streamlet : this.sources) {
            streamlet.build(builder, stageNames);
        }
        for (StreamletImpl<?> streamlet : this.sources) {
            if (streamlet.allBuilt()) continue;
            throw new RuntimeException("Topology cannot be fully built! Are all sources added?");
        }
        return builder;
    }
}

