/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.streamlet.impl;

import com.twitter.heron.api.bolt.BaseWindowedBolt;
import com.twitter.heron.api.tuple.Tuple;
import com.twitter.heron.api.windowing.EvictionPolicy;
import com.twitter.heron.api.windowing.TriggerPolicy;
import com.twitter.heron.streamlet.WindowConfig;
import java.time.Duration;

public final class WindowConfigImpl
implements WindowConfig {
    private WindowType windowType;
    private int windowSize;
    private int slideInterval;
    private Duration windowDuration;
    private Duration slidingIntervalDuration;
    private TriggerPolicy<Tuple, ?> triggerPolicy;
    private EvictionPolicy<Tuple, ?> evictionPolicy;

    public WindowConfigImpl(Duration windowDuration, Duration slidingIntervalDuration) {
        this.windowType = WindowType.TIME;
        this.windowDuration = windowDuration;
        this.slidingIntervalDuration = slidingIntervalDuration;
    }

    public WindowConfigImpl(int windowSize, int slideInterval) {
        this.windowType = WindowType.COUNT;
        this.windowSize = windowSize;
        this.slideInterval = slideInterval;
    }

    public WindowConfigImpl(TriggerPolicy<Tuple, ?> triggerPolicy, EvictionPolicy<Tuple, ?> evictionPolicy) {
        this.windowType = WindowType.CUSTOM;
        this.triggerPolicy = triggerPolicy;
        this.evictionPolicy = evictionPolicy;
    }

    public void attachWindowConfig(BaseWindowedBolt bolt) {
        switch (this.windowType) {
            case COUNT: {
                bolt.withWindow(BaseWindowedBolt.Count.of(this.windowSize), BaseWindowedBolt.Count.of(this.slideInterval));
                break;
            }
            case TIME: {
                bolt.withWindow(this.windowDuration, this.slidingIntervalDuration);
                break;
            }
            case CUSTOM: {
                bolt.withCustomEvictor(this.evictionPolicy);
                bolt.withCustomTrigger(this.triggerPolicy);
                break;
            }
            default: {
                throw new RuntimeException("Unknown windowType " + String.valueOf((Object)this.windowType));
            }
        }
    }

    private static enum WindowType {
        TIME,
        COUNT,
        CUSTOM;

    }
}

