/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.streamlet.impl.operators;

import com.twitter.heron.api.bolt.OutputCollector;
import com.twitter.heron.api.topology.TopologyContext;
import com.twitter.heron.api.tuple.Tuple;
import com.twitter.heron.api.tuple.Values;
import com.twitter.heron.streamlet.SerializableFunction;
import com.twitter.heron.streamlet.impl.operators.StreamletOperator;
import java.util.Map;

public class FlatMapOperator<R, T>
extends StreamletOperator {
    private static final long serialVersionUID = -2418329215159618998L;
    private SerializableFunction<? super R, ? extends Iterable<? extends T>> flatMapFn;
    private OutputCollector collector;

    public FlatMapOperator(SerializableFunction<? super R, ? extends Iterable<? extends T>> flatMapFn) {
        this.flatMapFn = flatMapFn;
    }

    public void prepare(Map map, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.collector = outputCollector;
    }

    @Override
    public void execute(Tuple tuple) {
        Object obj = tuple.getValue(0);
        Iterable result = (Iterable)this.flatMapFn.apply(obj);
        for (Object o : result) {
            this.collector.emit(new Values(o));
        }
        this.collector.ack(tuple);
    }
}

