/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.streamlet.impl.operators;

import com.twitter.heron.api.bolt.OutputCollector;
import com.twitter.heron.api.state.State;
import com.twitter.heron.api.topology.TopologyContext;
import com.twitter.heron.api.tuple.Tuple;
import com.twitter.heron.api.tuple.Values;
import com.twitter.heron.streamlet.SerializableTransformer;
import com.twitter.heron.streamlet.impl.ContextImpl;
import com.twitter.heron.streamlet.impl.operators.StreamletOperator;
import java.io.Serializable;
import java.util.Map;

public class TransformOperator<R, T>
extends StreamletOperator {
    private static final long serialVersionUID = 429297144878185182L;
    private SerializableTransformer<? super R, ? extends T> serializableTransformer;
    private OutputCollector collector;
    private State<Serializable, Serializable> state;

    public TransformOperator(SerializableTransformer<? super R, ? extends T> serializableTransformer) {
        this.serializableTransformer = serializableTransformer;
    }

    @Override
    public void initState(State<Serializable, Serializable> startupState) {
        this.state = startupState;
    }

    @Override
    public void cleanup() {
        this.serializableTransformer.cleanup();
    }

    @Override
    public void prepare(Map<String, Object> map, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.collector = outputCollector;
        ContextImpl context = new ContextImpl(topologyContext, map, this.state);
        this.serializableTransformer.setup(context);
    }

    @Override
    public void execute(Tuple tuple) {
        Object obj = tuple.getValue(0);
        this.serializableTransformer.transform(obj, x -> this.collector.emit(new Values(x)));
        this.collector.ack(tuple);
    }
}

