/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.streamlet.impl.streamlets;

import com.twitter.heron.api.topology.TopologyBuilder;
import com.twitter.heron.streamlet.SerializableFunction;
import com.twitter.heron.streamlet.impl.StreamletImpl;
import com.twitter.heron.streamlet.impl.operators.FlatMapOperator;
import java.util.Set;

public class FlatMapStreamlet<R, T>
extends StreamletImpl<T> {
    private StreamletImpl<R> parent;
    private SerializableFunction<? super R, ? extends Iterable<? extends T>> flatMapFn;

    public FlatMapStreamlet(StreamletImpl<R> parent, SerializableFunction<? super R, ? extends Iterable<? extends T>> flatMapFn) {
        this.parent = parent;
        this.flatMapFn = flatMapFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.FLATMAP, stageNames);
        bldr.setBolt(this.getName(), new FlatMapOperator(this.flatMapFn), (Number)this.getNumPartitions()).shuffleGrouping(this.parent.getName());
        return true;
    }
}

