/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.streamlet.impl.streamlets;

import com.twitter.heron.api.topology.TopologyBuilder;
import com.twitter.heron.streamlet.KeyValue;
import com.twitter.heron.streamlet.KeyedWindow;
import com.twitter.heron.streamlet.SerializableBiFunction;
import com.twitter.heron.streamlet.SerializableFunction;
import com.twitter.heron.streamlet.WindowConfig;
import com.twitter.heron.streamlet.impl.StreamletImpl;
import com.twitter.heron.streamlet.impl.WindowConfigImpl;
import com.twitter.heron.streamlet.impl.groupings.ReduceByKeyAndWindowCustomGrouping;
import com.twitter.heron.streamlet.impl.operators.GeneralReduceByKeyAndWindowOperator;
import java.util.Set;

public class GeneralReduceByKeyAndWindowStreamlet<K, V, VR>
extends StreamletImpl<KeyValue<KeyedWindow<K>, VR>> {
    private StreamletImpl<V> parent;
    private SerializableFunction<V, K> keyExtractor;
    private WindowConfigImpl windowCfg;
    private VR identity;
    private SerializableBiFunction<VR, V, ? extends VR> reduceFn;

    public GeneralReduceByKeyAndWindowStreamlet(StreamletImpl<V> parent, SerializableFunction<V, K> keyExtractor, WindowConfig windowCfg, VR identity, SerializableBiFunction<VR, V, ? extends VR> reduceFn) {
        this.parent = parent;
        this.keyExtractor = keyExtractor;
        this.windowCfg = (WindowConfigImpl)windowCfg;
        this.identity = identity;
        this.reduceFn = reduceFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.REDUCE, stageNames);
        GeneralReduceByKeyAndWindowOperator<K, V, ? extends VR> bolt = new GeneralReduceByKeyAndWindowOperator<K, V, VR>(this.keyExtractor, this.identity, this.reduceFn);
        this.windowCfg.attachWindowConfig(bolt);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).customGrouping(this.parent.getName(), new ReduceByKeyAndWindowCustomGrouping<K, V>(this.keyExtractor));
        return true;
    }
}

