/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.streamlet.impl.streamlets;

import com.twitter.heron.api.topology.TopologyBuilder;
import com.twitter.heron.streamlet.KeyValue;
import com.twitter.heron.streamlet.KeyedWindow;
import com.twitter.heron.streamlet.SerializableBinaryOperator;
import com.twitter.heron.streamlet.SerializableFunction;
import com.twitter.heron.streamlet.WindowConfig;
import com.twitter.heron.streamlet.impl.StreamletImpl;
import com.twitter.heron.streamlet.impl.WindowConfigImpl;
import com.twitter.heron.streamlet.impl.groupings.ReduceByKeyAndWindowCustomGrouping;
import com.twitter.heron.streamlet.impl.operators.ReduceByKeyAndWindowOperator;
import java.util.Set;

public class ReduceByKeyAndWindowStreamlet<K, V, R>
extends StreamletImpl<KeyValue<KeyedWindow<K>, V>> {
    private StreamletImpl<R> parent;
    private SerializableFunction<R, K> keyExtractor;
    private SerializableFunction<R, V> valueExtractor;
    private WindowConfigImpl windowCfg;
    private SerializableBinaryOperator<V> reduceFn;

    public ReduceByKeyAndWindowStreamlet(StreamletImpl<R> parent, SerializableFunction<R, K> keyExtractor, SerializableFunction<R, V> valueExtractor, WindowConfig windowCfg, SerializableBinaryOperator<V> reduceFn) {
        this.parent = parent;
        this.keyExtractor = keyExtractor;
        this.valueExtractor = valueExtractor;
        this.windowCfg = (WindowConfigImpl)windowCfg;
        this.reduceFn = reduceFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.REDUCE, stageNames);
        ReduceByKeyAndWindowOperator<K, V, R> bolt = new ReduceByKeyAndWindowOperator<K, V, R>(this.keyExtractor, this.valueExtractor, this.reduceFn);
        this.windowCfg.attachWindowConfig(bolt);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).customGrouping(this.parent.getName(), new ReduceByKeyAndWindowCustomGrouping<K, R>(this.keyExtractor));
        return true;
    }
}

