/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.streamlet.impl.streamlets;

import com.twitter.heron.api.topology.TopologyBuilder;
import com.twitter.heron.streamlet.impl.StreamletImpl;
import com.twitter.heron.streamlet.impl.operators.UnionOperator;
import java.util.Set;

public class UnionStreamlet<I>
extends StreamletImpl<I> {
    private StreamletImpl<I> left;
    private StreamletImpl<? extends I> right;

    public UnionStreamlet(StreamletImpl<I> left, StreamletImpl<? extends I> right) {
        this.left = left;
        this.right = right;
        this.setNumPartitions(left.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        if (!this.left.isBuilt() || !this.right.isBuilt()) {
            return false;
        }
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.UNION, stageNames);
        bldr.setBolt(this.getName(), new UnionOperator(), (Number)this.getNumPartitions()).shuffleGrouping(this.left.getName()).shuffleGrouping(this.right.getName());
        return true;
    }
}

