/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.Tracer;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.NullStatsReporter;
import com.uber.jaeger.metrics.StatsFactory;
import com.uber.jaeger.metrics.StatsFactoryImpl;
import com.uber.jaeger.reporters.CompositeReporter;
import com.uber.jaeger.reporters.LoggingReporter;
import com.uber.jaeger.reporters.RemoteReporter;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.samplers.ConstSampler;
import com.uber.jaeger.samplers.HTTPSamplingManager;
import com.uber.jaeger.samplers.ProbabilisticSampler;
import com.uber.jaeger.samplers.RateLimitingSampler;
import com.uber.jaeger.samplers.RemoteControlledSampler;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.senders.UDPSender;

public class Configuration {
    public static final double DEFAULT_SAMPLING_PROBABILITY = 0.001;
    private final String serviceName;
    private final SamplerConfiguration samplerConfig;
    private final ReporterConfiguration reporterConfig;
    private StatsFactory statsFactory;
    private Tracer tracer;

    public Configuration(String serviceName, SamplerConfiguration samplerConfig, ReporterConfiguration reporterConfig) {
        if (serviceName == null || serviceName.length() == 0) {
            throw new RuntimeException("Must provide a service name for Jaeger Configuration");
        }
        this.serviceName = serviceName;
        if (samplerConfig == null) {
            samplerConfig = new SamplerConfiguration(null, null, null);
        }
        this.samplerConfig = samplerConfig;
        if (reporterConfig == null) {
            reporterConfig = new ReporterConfiguration(null, null, null, null, null);
        }
        this.reporterConfig = reporterConfig;
        this.statsFactory = new StatsFactoryImpl(new NullStatsReporter());
    }

    public Tracer.Builder getTracerBuilder() {
        Metrics metrics = new Metrics(this.statsFactory);
        Reporter reporter = this.reporterConfig.getReporter(metrics);
        Sampler sampler = this.samplerConfig.createSampler(this.serviceName, metrics);
        return new Tracer.Builder(this.serviceName, reporter, sampler).withMetrics(metrics);
    }

    public synchronized io.opentracing.Tracer getTracer() {
        if (this.tracer != null) {
            return this.tracer;
        }
        this.tracer = this.getTracerBuilder().build();
        return this.tracer;
    }

    public void setStatsFactor(StatsFactory statsFactory) {
        this.statsFactory = statsFactory;
    }

    private static String stringOrDefault(String value, String defaultValue) {
        return value != null && value.length() > 0 ? value : defaultValue;
    }

    private static Number numberOrDefault(Number value, Number defaultValue) {
        return value != null ? (Number)value : (Number)defaultValue;
    }

    public static class ReporterConfiguration {
        private static final String defaultAgentHost = "localhost";
        private static final int defaultAgentPort = 5775;
        private static final int defaultFlushIntervalMs = 1000;
        private static final int defaultMaxQueueSize = 100;
        private final Boolean logSpans;
        private final String agentHost;
        private final Integer agentPort;
        private final Integer flushIntervalMs;
        private final Integer maxQueueSize;

        public ReporterConfiguration() {
            this(null, null, null, null, null);
        }

        public ReporterConfiguration(Boolean logSpans, String agentHost, Integer agentPort, Integer flushIntervalMs, Integer maxQueueSize) {
            this.logSpans = logSpans;
            this.agentHost = agentHost;
            this.agentPort = agentPort;
            this.flushIntervalMs = flushIntervalMs;
            this.maxQueueSize = maxQueueSize;
        }

        private Reporter getReporter(Metrics metrics) {
            UDPSender sender = new UDPSender(Configuration.stringOrDefault(this.agentHost, defaultAgentHost), Configuration.numberOrDefault(this.agentPort, 5775).intValue(), 0);
            Reporter reporter = new RemoteReporter(sender, Configuration.numberOrDefault(this.flushIntervalMs, 1000).intValue(), Configuration.numberOrDefault(this.maxQueueSize, 100).intValue(), metrics);
            if (Boolean.TRUE.equals(this.logSpans)) {
                LoggingReporter loggingReporter = new LoggingReporter();
                reporter = new CompositeReporter(reporter, loggingReporter);
            }
            return reporter;
        }

        public Boolean getLogSpans() {
            return this.logSpans;
        }

        public String getAgentHost() {
            return this.agentHost;
        }

        public Integer getAgentPort() {
            return this.agentPort;
        }

        public Integer getFlushIntervalMs() {
            return this.flushIntervalMs;
        }

        public Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }
    }

    public static class SamplerConfiguration {
        private static final String defaultManagerHostPort = "localhost:5778";
        private final String type;
        private final Number param;
        private final String managerHostPort;

        public SamplerConfiguration(String type, Number param) {
            this(type, param, null);
        }

        public SamplerConfiguration() {
            this(null, null, null);
        }

        public SamplerConfiguration(String type, Number param, String managerHostPort) {
            this.type = type;
            this.param = param;
            this.managerHostPort = managerHostPort;
        }

        private Sampler createSampler(String serviceName, Metrics metrics) {
            String samplerType = Configuration.stringOrDefault(this.getType(), "remote");
            Number samplerParam = Configuration.numberOrDefault(this.getParam(), 0.001);
            String hostPort = Configuration.stringOrDefault(this.getManagerHostPort(), defaultManagerHostPort);
            if (samplerType.equals("const")) {
                return new ConstSampler(samplerParam.intValue() != 0);
            }
            if (samplerType.equals("probabilistic")) {
                return new ProbabilisticSampler(samplerParam.doubleValue());
            }
            if (samplerType.equals("ratelimiting")) {
                return new RateLimitingSampler(samplerParam.intValue());
            }
            if (samplerType.equals("remote")) {
                ProbabilisticSampler initialSampler = new ProbabilisticSampler(samplerParam.doubleValue());
                HTTPSamplingManager manager = new HTTPSamplingManager(hostPort);
                return new RemoteControlledSampler(serviceName, manager, initialSampler, metrics);
            }
            throw new IllegalStateException(String.format("Invalid sampling strategy %s", samplerType));
        }

        public String getType() {
            return this.type;
        }

        public Number getParam() {
            return this.param;
        }

        public String getManagerHostPort() {
            return this.managerHostPort;
        }
    }
}

