/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.metrics;

import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.StatsReporter;
import java.util.HashMap;
import java.util.Map;

public class InMemoryStatsReporter
implements StatsReporter {
    public Map<String, Long> counters = new HashMap<String, Long>();
    public Map<String, Long> gauges = new HashMap<String, Long>();
    public Map<String, Long> timers = new HashMap<String, Long>();

    void reset() {
        this.counters = new HashMap<String, Long>();
        this.gauges = new HashMap<String, Long>();
        this.timers = new HashMap<String, Long>();
    }

    @Override
    public void incCounter(String name, long delta, Map<String, String> tags) {
        String metricName = Metrics.addTagsToMetricName(name, tags);
        long initialValue = 0L;
        if (this.counters.containsKey(metricName)) {
            initialValue = this.counters.get(metricName);
        }
        this.counters.put(metricName, initialValue + delta);
    }

    @Override
    public void recordTimer(String name, long time, Map<String, String> tags) {
        String metricName = Metrics.addTagsToMetricName(name, tags);
        long initialValue = 0L;
        if (this.counters.containsKey(metricName)) {
            initialValue = this.counters.get(metricName);
        }
        this.timers.put(metricName, initialValue + time);
    }

    @Override
    public void updateGauge(String name, long amount, Map<String, String> tags) {
        String metricName = Metrics.addTagsToMetricName(name, tags);
        long initialValue = 0L;
        if (this.counters.containsKey(metricName)) {
            initialValue = this.counters.get(metricName);
        }
        this.gauges.put(metricName, initialValue + amount);
    }
}

