/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.metrics;

import com.uber.jaeger.metrics.Counter;
import com.uber.jaeger.metrics.Gauge;
import com.uber.jaeger.metrics.Metric;
import com.uber.jaeger.metrics.StatsFactory;
import com.uber.jaeger.metrics.StatsFactoryImpl;
import com.uber.jaeger.metrics.StatsReporter;
import com.uber.jaeger.metrics.Tag;
import com.uber.jaeger.metrics.Timer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class Metrics {
    @Metric(name="traces", tags={@Tag(key="state", value="started"), @Tag(key="sampled", value="y")})
    public Counter traceStartedSampled;
    @Metric(name="traces", tags={@Tag(key="state", value="started"), @Tag(key="sampled", value="n")})
    public Counter traceStartedNotSampled;
    @Metric(name="traces", tags={@Tag(key="state", value="joined"), @Tag(key="sampled", value="y")})
    public Counter tracesJoinedSampled;
    @Metric(name="traces", tags={@Tag(key="state", value="joined"), @Tag(key="sampled", value="n")})
    public Counter tracesJoinedNotSampled;
    @Metric(name="spans", tags={@Tag(key="state", value="started"), @Tag(key="group", value="lifecycle")})
    public Counter spansStarted;
    @Metric(name="spans", tags={@Tag(key="state", value="finished"), @Tag(key="group", value="lifecycle")})
    public Counter spansFinished;
    @Metric(name="spans", tags={@Tag(key="group", value="sampling"), @Tag(key="sampled", value="y")})
    public Counter spansSampled;
    @Metric(name="spans", tags={@Tag(key="group", value="sampling"), @Tag(key="sampled", value="n")})
    public Counter spansNotSampled;
    @Metric(name="decoding-errors")
    public Counter decodingErrors;
    @Metric(name="reporter-spans", tags={@Tag(key="state", value="success")})
    public Counter reporterSuccess;
    @Metric(name="reporter-spans", tags={@Tag(key="state", value="failure")})
    public Counter reporterFailure;
    @Metric(name="spans", tags={@Tag(key="state", value="dropped")})
    public Counter reporterDropped;
    @Metric(name="reporter-queue")
    public Gauge reporterQueueLength;
    @Metric(name="sampler", tags={@Tag(key="state", value="retrieved")})
    public Counter samplerRetrieved;
    @Metric(name="sampler", tags={@Tag(key="state", value="updated")})
    public Counter samplerUpdated;
    @Metric(name="sampler", tags={@Tag(key="state", value="failure"), @Tag(key="phase", value="query")})
    public Counter samplerQueryFailure;
    @Metric(name="sampler", tags={@Tag(key="state", value="failure"), @Tag(key="phase", value="parsing")})
    public Counter samplerParsingFailure;

    public Metrics(StatsFactory factory) {
        for (Field field : Metrics.class.getDeclaredFields()) {
            Annotation[] annotations;
            if (!Counter.class.isAssignableFrom(field.getType()) && !Timer.class.isAssignableFrom(field.getType()) && !Gauge.class.isAssignableFrom(field.getType())) continue;
            String metricName = "jaeger.";
            HashMap<String, String> tags = new HashMap<String, String>();
            for (Annotation anno : annotations = field.getAnnotations()) {
                Tag[] entries;
                if (!anno.annotationType().equals(Metric.class)) continue;
                Metric metricAnno = (Metric)anno;
                metricName = metricName + metricAnno.name();
                for (Tag t : entries = metricAnno.tags()) {
                    tags.put(t.key(), t.value());
                }
            }
            try {
                if (field.getType().equals(Counter.class)) {
                    field.set(this, factory.createCounter(metricName, tags));
                    continue;
                }
                if (field.getType().equals(Gauge.class)) {
                    field.set(this, factory.createGauge(metricName, tags));
                    continue;
                }
                if (field.getType().equals(Timer.class)) {
                    field.set(this, factory.createTimer(metricName, tags));
                    continue;
                }
                throw new RuntimeException("A field type that was neither Counter, Gauge, or Timer was parsed in reflection.");
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("No reflection exceptions should be thrown unless there is a fundamental error in your code set up.", e);
            }
        }
    }

    public static String addTagsToMetricName(String name, Map<String, String> tags) {
        if (tags == null || tags.size() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        TreeSet<String> sortedKeys = new TreeSet<String>(tags.keySet());
        for (String key : sortedKeys) {
            sb.append(".");
            sb.append(key);
            sb.append("=");
            sb.append(tags.get(key));
        }
        return sb.toString();
    }

    public static Metrics fromStatsReporter(StatsReporter reporter) {
        return new Metrics(new StatsFactoryImpl(reporter));
    }
}

