/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.reporters.protocols;

import com.twitter.zipkin.thriftjava.Annotation;
import com.twitter.zipkin.thriftjava.AnnotationType;
import com.twitter.zipkin.thriftjava.BinaryAnnotation;
import com.twitter.zipkin.thriftjava.Endpoint;
import com.uber.jaeger.LogData;
import com.uber.jaeger.Span;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.Tracer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThriftSpanConverter {
    public static com.twitter.zipkin.thriftjava.Span convertSpan(Span span) {
        Tracer tracer = span.getTracer();
        Endpoint host = new Endpoint(tracer.getIP(), 0, tracer.getServiceName());
        SpanContext context = span.getContext();
        return new com.twitter.zipkin.thriftjava.Span(context.getTraceID(), span.getOperationName(), context.getSpanID(), ThriftSpanConverter.buildAnnotations(span, host), ThriftSpanConverter.buildBinaryAnnotations(span, host)).setParent_id(context.getParentID()).setDebug(context.isDebug()).setTimestamp(span.getStart()).setDuration(span.getDuration());
    }

    private static List<Annotation> buildAnnotations(Span span, Endpoint host) {
        List<LogData> logs;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (span.isRPC()) {
            String startLabel = "sr";
            String endLabel = "ss";
            if (span.isRPCClient()) {
                startLabel = "cs";
                endLabel = "cr";
            }
            annotations.add(new Annotation(span.getStart(), startLabel).setHost(host));
            annotations.add(new Annotation(span.getStart() + span.getDuration(), endLabel).setHost(host));
        }
        if ((logs = span.getLogs()) != null) {
            for (LogData logData : logs) {
                annotations.add(new Annotation(logData.getTime(), logData.getMessage()));
            }
        }
        return annotations;
    }

    private static List<BinaryAnnotation> buildBinaryAnnotations(Span span, Endpoint host) {
        Map<String, Object> tags;
        ArrayList<BinaryAnnotation> binaryAnnotations = new ArrayList<BinaryAnnotation>();
        if (span.getPeer() != null && span.isRPC()) {
            String label = span.isRPCClient() ? "sa" : "ca";
            binaryAnnotations.add(new BinaryAnnotation().setKey(label).setValue(new byte[]{1}).setAnnotation_type(AnnotationType.BOOL).setHost(span.getPeer()));
        }
        if (!span.isRPC()) {
            byte[] componentName = span.getLocalComponent() != null ? span.getLocalComponent().getBytes(StandardCharsets.UTF_8) : span.getTracer().getServiceName().getBytes(StandardCharsets.UTF_8);
            binaryAnnotations.add(new BinaryAnnotation().setKey("lc").setValue(componentName).setAnnotation_type(AnnotationType.STRING).setHost(host));
        }
        if ((tags = span.getTags()) != null) {
            for (String tagKey : tags.keySet()) {
                Object tagValue = tags.get(tagKey);
                binaryAnnotations.add(ThriftSpanConverter.buildBinaryAnnotation(tagKey, tagValue));
            }
        }
        return binaryAnnotations;
    }

    private static BinaryAnnotation buildBinaryAnnotation(String tagKey, Object tagValue) {
        BinaryAnnotation banno = new BinaryAnnotation().setKey(tagKey);
        String stringTagValue = tagValue.toString();
        if (stringTagValue.length() > 256) {
            tagValue = stringTagValue.substring(0, 256);
        }
        banno.setValue(stringTagValue.getBytes(StandardCharsets.UTF_8)).setAnnotation_type(AnnotationType.STRING);
        return banno;
    }
}

