/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.uber.jaeger.exceptions.SamplingStrategyErrorException;
import com.uber.jaeger.samplers.SamplingManager;
import com.uber.jaeger.thrift.sampling_manager.ProbabilisticSamplingStrategy;
import com.uber.jaeger.thrift.sampling_manager.RateLimitingSamplingStrategy;
import com.uber.jaeger.thrift.sampling_manager.SamplingStrategyResponse;
import com.uber.jaeger.thrift.sampling_manager.SamplingStrategyType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class HTTPSamplingManager
implements SamplingManager {
    private static final String defaultSamplingServerHostPort = "localhost:5778";
    private String hostPort = "localhost:5778";

    public HTTPSamplingManager(String hostPort) {
        if (hostPort != null) {
            this.hostPort = hostPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeGetRequest(String urlToRead) throws IOException {
        URL url = new URL(urlToRead);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        StringBuilder result = new StringBuilder();
        try {
            conn.setRequestMethod("GET");
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
            }
        }
        finally {
            conn.disconnect();
        }
        return result.toString();
    }

    private SamplingStrategyResponse jsonStringToSamplingStrategy(String jsonString) {
        HashMap result;
        try {
            result = (HashMap)new ObjectMapper().readValue(jsonString, HashMap.class);
        }
        catch (IOException e) {
            throw new SamplingStrategyErrorException("Invalid json received when fetching sampling strategy from local agent.", e);
        }
        SamplingStrategyType samplingType = SamplingStrategyType.findByValue((int)((Integer)result.get("strategyType")));
        if (samplingType == SamplingStrategyType.PROBABILISTIC) {
            Double samplingRate;
            try {
                samplingRate = (Double)((HashMap)result.get("probabilisticSampling")).get("samplingRate");
            }
            catch (Exception e) {
                throw new SamplingStrategyErrorException(String.format("Unexpected format %s for parsing probabilistic sampling strategy", jsonString));
            }
            return new SamplingStrategyResponse(samplingType).setProbabilisticSampling(new ProbabilisticSamplingStrategy(samplingRate.doubleValue()));
        }
        if (samplingType == SamplingStrategyType.RATE_LIMITING) {
            int maxTracesPerSecond;
            try {
                maxTracesPerSecond = (Integer)((HashMap)result.get("rateLimitingSampling")).get("maxTracesPerSecond");
            }
            catch (Exception e) {
                throw new SamplingStrategyErrorException(String.format("Unexpected format %s for parsing rateLimiting sampling strategy", jsonString));
            }
            return new SamplingStrategyResponse(samplingType).setRateLimitingSampling(new RateLimitingSamplingStrategy((short)maxTracesPerSecond));
        }
        throw new SamplingStrategyErrorException("Unrecognized sampling strategy type.");
    }

    @Override
    public SamplingStrategyResponse getSamplingStrategy(String serviceName) throws SamplingStrategyErrorException {
        String jsonString;
        try {
            jsonString = this.makeGetRequest("http://" + this.hostPort + "/?service=" + URLEncoder.encode(serviceName, "UTF-8"));
        }
        catch (IOException e) {
            throw new SamplingStrategyErrorException("http call to get sampling strategy from local agent failed.", e);
        }
        return this.jsonStringToSamplingStrategy(jsonString);
    }
}

