/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.utils.RateLimiter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RateLimitingSampler
implements Sampler {
    public static final String TYPE = "ratelimiting";
    private final RateLimiter rateLimiter;
    private final int maxTracesPerSecond;
    private final Map<String, Object> tags;

    public RateLimitingSampler(int maxTracesPerSecond) {
        this.maxTracesPerSecond = maxTracesPerSecond;
        this.rateLimiter = new RateLimiter(maxTracesPerSecond);
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.put("sampler.type", TYPE);
        tags.put("sampler.param", maxTracesPerSecond);
        this.tags = Collections.unmodifiableMap(tags);
    }

    @Override
    public boolean isSampled(long id) {
        return this.rateLimiter.checkCredit(1.0);
    }

    @Override
    public Map<String, Object> getTags() {
        return this.tags;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RateLimitingSampler) {
            return this.maxTracesPerSecond == ((RateLimitingSampler)other).maxTracesPerSecond;
        }
        return false;
    }

    @Override
    public void close() {
    }
}

