/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.uber.jaeger.exceptions.SamplingStrategyErrorException;
import com.uber.jaeger.exceptions.UnknownSamplingStrategyException;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.samplers.ProbabilisticSampler;
import com.uber.jaeger.samplers.RateLimitingSampler;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.samplers.SamplingManager;
import com.uber.jaeger.thrift.sampling_manager.ProbabilisticSamplingStrategy;
import com.uber.jaeger.thrift.sampling_manager.RateLimitingSamplingStrategy;
import com.uber.jaeger.thrift.sampling_manager.SamplingStrategyResponse;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RemoteControlledSampler
implements Sampler {
    public static final String TYPE = "remote";
    private final String serviceName;
    private final SamplingManager manager;
    private final Timer pollTimer;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Sampler sampler;
    private Metrics metrics;

    public RemoteControlledSampler(String serviceName, SamplingManager manager, Sampler initial, Metrics metrics) {
        int pollingIntervalMs = 60000;
        this.serviceName = serviceName;
        this.manager = manager;
        this.metrics = metrics;
        this.sampler = initial != null ? initial : new ProbabilisticSampler(0.001);
        this.pollTimer = new Timer(true);
        this.pollTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RemoteControlledSampler.this.updateSampler();
            }
        }, 0L, 60000L);
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSampler() {
        Sampler newSampler;
        SamplingStrategyResponse response;
        try {
            response = this.manager.getSamplingStrategy(this.serviceName);
            this.metrics.samplerRetrieved.inc(1L);
        }
        catch (SamplingStrategyErrorException e) {
            this.metrics.samplerQueryFailure.inc(1L);
            return;
        }
        try {
            newSampler = this.extractSampler(response);
        }
        catch (UnknownSamplingStrategyException e) {
            this.metrics.samplerParsingFailure.inc(1L);
            return;
        }
        if (!this.sampler.equals(newSampler)) {
            RemoteControlledSampler remoteControlledSampler = this;
            synchronized (remoteControlledSampler) {
                this.sampler = newSampler;
                this.metrics.samplerUpdated.inc(1L);
            }
        }
    }

    private Sampler extractSampler(SamplingStrategyResponse response) throws UnknownSamplingStrategyException {
        if (response.isSetProbabilisticSampling()) {
            ProbabilisticSamplingStrategy strategy = response.getProbabilisticSampling();
            return new ProbabilisticSampler(strategy.getSamplingRate());
        }
        if (response.isSetRateLimitingSampling()) {
            RateLimitingSamplingStrategy strategy = response.getRateLimitingSampling();
            return new RateLimitingSampler(strategy.getMaxTracesPerSecond());
        }
        throw new UnknownSamplingStrategyException(String.format("Unsupported sampling strategy type %s", response.getStrategyType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSampled(long id) {
        RemoteControlledSampler remoteControlledSampler = this;
        synchronized (remoteControlledSampler) {
            return this.sampler.isSampled(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getTags() {
        RemoteControlledSampler remoteControlledSampler = this;
        synchronized (remoteControlledSampler) {
            return this.sampler.getTags();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object sampler) {
        if (this == sampler) {
            return true;
        }
        if (sampler instanceof RemoteControlledSampler) {
            RemoteControlledSampler remoteSampler = (RemoteControlledSampler)sampler;
            RemoteControlledSampler remoteControlledSampler = this;
            synchronized (remoteControlledSampler) {
                boolean bl;
                ReentrantReadWriteLock.ReadLock readLock = remoteSampler.getLock().readLock();
                readLock.lock();
                try {
                    bl = this.sampler.equals(remoteSampler.sampler);
                    readLock.unlock();
                }
                catch (Throwable throwable) {
                    readLock.unlock();
                    throw throwable;
                }
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RemoteControlledSampler remoteControlledSampler = this;
        synchronized (remoteControlledSampler) {
            this.pollTimer.cancel();
        }
    }
}

