/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.utils;

import com.uber.jaeger.exceptions.EmptyIPException;
import com.uber.jaeger.exceptions.NotFourOctetsException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadLocalRandom;

public class Utils {
    public static String normalizeBaggageKey(String key) {
        return key.replaceAll("_", "-").toLowerCase();
    }

    public static int ipToInt(String ip) throws EmptyIPException, NotFourOctetsException {
        InetAddress octets;
        if (ip.equals("")) {
            throw new EmptyIPException();
        }
        if (ip.equals("localhost")) {
            return 2130706433;
        }
        try {
            octets = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            throw new NotFourOctetsException();
        }
        int intIP = 0;
        for (byte octet : octets.getAddress()) {
            intIP = intIP << 8 | octet;
        }
        return intIP;
    }

    public static long uniqueID() {
        long val = 0L;
        while (val == 0L) {
            val = ThreadLocalRandom.current().nextLong();
        }
        return val;
    }
}

