/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.LogData;
import com.uber.jaeger.Reference;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.Tracer;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Span
implements io.opentracing.Span {
    private final Tracer tracer;
    private final long startTimeMicroseconds;
    private final long startTimeNanoTicks;
    private final boolean computeDurationViaNanoTicks;
    private final Map<String, Object> tags;
    private long durationMicroseconds;
    private String operationName;
    private final List<Reference> references;
    private SpanContext context;
    private List<LogData> logs;

    Span(Tracer tracer, String operationName, SpanContext context, long startTimeMicroseconds, long startTimeNanoTicks, boolean computeDurationViaNanoTicks, Map<String, Object> tags, List<Reference> references) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.context = context;
        this.startTimeMicroseconds = startTimeMicroseconds;
        this.startTimeNanoTicks = startTimeNanoTicks;
        this.computeDurationViaNanoTicks = computeDurationViaNanoTicks;
        this.tags = new HashMap<String, Object>();
        this.references = references != null ? new ArrayList<Reference>(references) : null;
        for (Map.Entry<String, Object> tag : tags.entrySet()) {
            this.setTagAsObject(tag.getKey(), tag.getValue());
        }
    }

    public long getStart() {
        return this.startTimeMicroseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        Span span = this;
        synchronized (span) {
            return this.durationMicroseconds;
        }
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public List<Reference> getReferences() {
        if (this.references == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.references);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        Span span = this;
        synchronized (span) {
            return Collections.unmodifiableMap(this.tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span setOperationName(String operationName) {
        Span span = this;
        synchronized (span) {
            this.operationName = operationName;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOperationName() {
        Span span = this;
        synchronized (span) {
            return this.operationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogData> getLogs() {
        Span span = this;
        synchronized (span) {
            if (this.logs == null) {
                return null;
            }
            return Collections.unmodifiableList(this.logs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span setBaggageItem(String key, String value) {
        Span span = this;
        synchronized (span) {
            this.context = this.context.withBaggageItem(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaggageItem(String key) {
        Span span = this;
        synchronized (span) {
            return this.context.getBaggageItem(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Span span = this;
        synchronized (span) {
            return this.context.contextAsString() + " - " + this.operationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpanContext context() {
        Span span = this;
        synchronized (span) {
            return this.context;
        }
    }

    public void finish() {
        if (this.computeDurationViaNanoTicks) {
            long nanoDuration = this.tracer.clock().currentNanoTicks() - this.startTimeNanoTicks;
            this.finishWithDuration(nanoDuration / 1000L);
        } else {
            this.finish(this.tracer.clock().currentTimeMicros());
        }
    }

    public void finish(long finishMicros) {
        this.finishWithDuration(finishMicros - this.startTimeMicroseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWithDuration(long durationMicros) {
        Span span = this;
        synchronized (span) {
            this.durationMicroseconds = durationMicros;
        }
        if (this.context.isSampled()) {
            this.tracer.reportSpan(this);
        }
    }

    public synchronized Span setTag(String key, String value) {
        return this.setTagAsObject(key, value);
    }

    public synchronized Span setTag(String key, boolean value) {
        return this.setTagAsObject(key, value);
    }

    public synchronized Span setTag(String key, Number value) {
        return this.setTagAsObject(key, value);
    }

    private Span setTagAsObject(String key, Object value) {
        if (key.equals(Tags.SAMPLING_PRIORITY.getKey()) && value instanceof Number) {
            int priority = ((Number)value).intValue();
            byte newFlags = priority > 0 ? (byte)(this.context.getFlags() | 1 | 2) : (byte)(this.context.getFlags() & 0xFFFFFFFE);
            this.context = this.context.withFlags(newFlags);
        }
        if (this.context.isSampled()) {
            this.tags.put(key, value);
        }
        return this;
    }

    public Span log(Map<String, ?> fields) {
        return this.log(this.tracer.clock().currentTimeMicros(), fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        Span span = this;
        synchronized (span) {
            if (fields == null) {
                return this;
            }
            if (this.context.isSampled()) {
                if (this.logs == null) {
                    this.logs = new ArrayList<LogData>();
                }
                this.logs.add(new LogData(timestampMicroseconds, fields));
            }
            return this;
        }
    }

    public Span log(String event) {
        return this.log(this.tracer.clock().currentTimeMicros(), event, null);
    }

    public Span log(long timestampMicroseconds, String event) {
        return this.log(timestampMicroseconds, event, null);
    }

    public Span log(String message, Object payload) {
        return this.log(this.tracer.clock().currentTimeMicros(), message, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span log(long timestampMicroseconds, String message, Object payload) {
        Span span = this;
        synchronized (span) {
            if (message == null && payload == null) {
                return this;
            }
            if (this.context.isSampled()) {
                if (this.logs == null) {
                    this.logs = new ArrayList<LogData>();
                }
                this.logs.add(new LogData(timestampMicroseconds, message, payload));
            }
            return this;
        }
    }
}

