/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.reporters;

import com.uber.jaeger.Span;
import com.uber.jaeger.reporters.Reporter;
import java.util.ArrayList;
import java.util.List;

public class CompositeReporter
implements Reporter {
    private final List<Reporter> reporters = new ArrayList<Reporter>();

    public CompositeReporter(Reporter ... reporters) {
        for (int i = 0; i < reporters.length; ++i) {
            this.reporters.add(reporters[i]);
        }
    }

    @Override
    public void report(Span span) {
        for (Reporter reporter : this.reporters) {
            reporter.report(span);
        }
    }

    @Override
    public void close() {
        for (Reporter reporter : this.reporters) {
            reporter.close();
        }
    }

    public String toString() {
        return "CompositeReporter(reporters=" + this.reporters + ")";
    }
}

