/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.reporters;

import com.uber.jaeger.Span;
import com.uber.jaeger.exceptions.SenderException;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.senders.Sender;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(RemoteReporter.class);
    private static final int DEFAULT_CLOSE_ENQUEUE_TIMEOUT_MILLIS = 1000;
    private final BlockingQueue<Command> commandQueue;
    private final Timer flushTimer;
    private final Thread queueProcessorThread;
    private final QueueProcessor queueProcessor;
    private final Sender sender;
    private final int maxQueueSize;
    private final int closeEnqueueTimeout;
    private final Metrics metrics;

    public RemoteReporter(Sender sender, int flushInterval, int maxQueueSize, Metrics metrics) {
        this(sender, flushInterval, maxQueueSize, 1000, metrics);
    }

    RemoteReporter(Sender sender, int flushInterval, int maxQueueSize, int closeEnqueueTimeout, Metrics metrics) {
        this.sender = sender;
        this.maxQueueSize = maxQueueSize;
        this.metrics = metrics;
        this.closeEnqueueTimeout = closeEnqueueTimeout;
        this.commandQueue = new ArrayBlockingQueue<Command>(maxQueueSize);
        this.queueProcessor = new QueueProcessor();
        this.queueProcessorThread = new Thread((Runnable)this.queueProcessor, "jaeger.RemoteReporter-QueueProcessor");
        this.queueProcessorThread.setDaemon(true);
        this.queueProcessorThread.start();
        this.flushTimer = new Timer("jaeger.RemoteReporter-FlushTimer", true);
        this.flushTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RemoteReporter.this.flush();
            }
        }, flushInterval, (long)flushInterval);
    }

    @Override
    public void report(Span span) {
        boolean added = this.commandQueue.offer(new AppendCommand(span));
        if (!added) {
            this.metrics.reporterDropped.inc(1L);
        }
    }

    @Override
    public void close() {
        try {
            boolean added = this.commandQueue.offer(new CloseCommand(), this.closeEnqueueTimeout, TimeUnit.MILLISECONDS);
            if (added) {
                this.queueProcessorThread.join();
            } else {
                log.warn("Unable to cleanly close RemoteReporter, command queue is full - probably the sender is stuck");
            }
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            try {
                int n = this.sender.close();
                this.metrics.reporterSuccess.inc(n);
            }
            catch (SenderException e) {
                this.metrics.reporterFailure.inc(e.getDroppedSpanCount());
            }
            this.flushTimer.cancel();
        }
    }

    void flush() {
        this.metrics.reporterQueueLength.update(this.commandQueue.size());
        this.commandQueue.offer(new FlushCommand());
    }

    public String toString() {
        return "RemoteReporter(queueProcessor=" + this.queueProcessor + ", sender=" + this.sender + ", maxQueueSize=" + this.maxQueueSize + ", closeEnqueueTimeout=" + this.closeEnqueueTimeout + ")";
    }

    class QueueProcessor
    implements Runnable {
        private boolean open = true;

        QueueProcessor() {
        }

        @Override
        public void run() {
            while (this.open) {
                try {
                    Command command = (Command)RemoteReporter.this.commandQueue.take();
                    try {
                        command.execute();
                    }
                    catch (SenderException e) {
                        ((RemoteReporter)RemoteReporter.this).metrics.reporterFailure.inc(e.getDroppedSpanCount());
                    }
                }
                catch (InterruptedException e) {
                    log.error("QueueProcessor error:", (Throwable)e);
                }
            }
        }

        public void close() {
            this.open = false;
        }

        public String toString() {
            return "RemoteReporter.QueueProcessor(open=" + this.open + ")";
        }
    }

    class FlushCommand
    implements Command {
        FlushCommand() {
        }

        @Override
        public void execute() throws SenderException {
            int n = RemoteReporter.this.sender.flush();
            ((RemoteReporter)RemoteReporter.this).metrics.reporterSuccess.inc(n);
        }
    }

    class CloseCommand
    implements Command {
        CloseCommand() {
        }

        @Override
        public void execute() throws SenderException {
            RemoteReporter.this.queueProcessor.close();
        }
    }

    class AppendCommand
    implements Command {
        private final Span span;

        public AppendCommand(Span span) {
            this.span = span;
        }

        @Override
        public void execute() throws SenderException {
            RemoteReporter.this.sender.append(this.span);
        }
    }

    public static interface Command {
        public void execute() throws SenderException;
    }
}

