/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.reporters.protocols;

import com.uber.jaeger.LogData;
import com.uber.jaeger.Reference;
import com.uber.jaeger.Span;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.thriftjava.Log;
import com.uber.jaeger.thriftjava.SpanRef;
import com.uber.jaeger.thriftjava.SpanRefType;
import com.uber.jaeger.thriftjava.Tag;
import com.uber.jaeger.thriftjava.TagType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JaegerThriftSpanConverter {
    private JaegerThriftSpanConverter() {
    }

    public static com.uber.jaeger.thriftjava.Span convertSpan(Span span) {
        SpanContext context = span.context();
        boolean oneChildOfParent = span.getReferences().size() == 1 && "child_of".equals(span.getReferences().get(0).getType());
        return new com.uber.jaeger.thriftjava.Span(context.getTraceId(), 0L, context.getSpanId(), oneChildOfParent ? context.getParentId() : 0L, span.getOperationName(), (int)context.getFlags(), span.getStart(), span.getDuration()).setReferences(oneChildOfParent ? Collections.emptyList() : JaegerThriftSpanConverter.buildReferences(span.getReferences())).setTags(JaegerThriftSpanConverter.buildTags(span.getTags())).setLogs(JaegerThriftSpanConverter.buildLogs(span.getLogs()));
    }

    static List<SpanRef> buildReferences(List<Reference> references) {
        ArrayList<SpanRef> thriftReferences = new ArrayList<SpanRef>(references.size());
        for (Reference reference : references) {
            SpanRefType thriftRefType = "child_of".equals(reference.getType()) ? SpanRefType.CHILD_OF : SpanRefType.FOLLOWS_FROM;
            thriftReferences.add(new SpanRef(thriftRefType, reference.getSpanContext().getTraceId(), 0L, reference.getSpanContext().getSpanId()));
        }
        return thriftReferences;
    }

    static List<Log> buildLogs(List<LogData> logs) {
        ArrayList<Log> thriftLogs = new ArrayList<Log>();
        if (logs != null) {
            for (LogData logData : logs) {
                Log thriftLog = new Log();
                thriftLog.setTimestamp(logData.getTime());
                if (logData.getFields() != null) {
                    thriftLog.setFields(JaegerThriftSpanConverter.buildTags(logData.getFields()));
                } else {
                    ArrayList<Tag> tags = new ArrayList<Tag>();
                    if (logData.getMessage() != null) {
                        tags.add(JaegerThriftSpanConverter.buildTag("event", logData.getMessage()));
                    }
                    if (logData.getPayload() != null) {
                        tags.add(JaegerThriftSpanConverter.buildTag("payload", logData.getPayload()));
                    }
                    thriftLog.setFields(tags);
                }
                thriftLogs.add(thriftLog);
            }
        }
        return thriftLogs;
    }

    public static List<Tag> buildTags(Map<String, ?> tags) {
        ArrayList<Tag> thriftTags = new ArrayList<Tag>();
        if (tags != null) {
            for (Map.Entry<String, ?> entry : tags.entrySet()) {
                String tagKey = entry.getKey();
                Object tagValue = entry.getValue();
                thriftTags.add(JaegerThriftSpanConverter.buildTag(tagKey, tagValue));
            }
        }
        return thriftTags;
    }

    static Tag buildTag(String tagKey, Object tagValue) {
        Tag tag = new Tag();
        tag.setKey(tagKey);
        if (tagValue instanceof Integer || tagValue instanceof Short || tagValue instanceof Long) {
            tag.setVType(TagType.LONG);
            tag.setVLong(((Number)tagValue).longValue());
        } else if (tagValue instanceof Double || tagValue instanceof Float) {
            tag.setVType(TagType.DOUBLE);
            tag.setVDouble(((Number)tagValue).doubleValue());
        } else if (tagValue instanceof Boolean) {
            tag.setVType(TagType.BOOL);
            tag.setVBool(((Boolean)tagValue).booleanValue());
        } else {
            JaegerThriftSpanConverter.buildStringTag(tag, tagValue);
        }
        return tag;
    }

    static void buildStringTag(Tag tag, Object tagValue) {
        tag.setVType(TagType.STRING);
        tag.setVStr(String.valueOf(tagValue));
    }
}

