/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.senders;

import com.uber.jaeger.Span;
import com.uber.jaeger.exceptions.SenderException;
import com.uber.jaeger.reporters.protocols.JaegerThriftSpanConverter;
import com.uber.jaeger.senders.Sender;
import com.uber.jaeger.thriftjava.Process;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import org.apache.thrift.transport.TTransport;

public abstract class ThriftSender
implements Sender {
    static final int EMIT_BATCH_OVERHEAD = 33;
    private Process process;
    private int processBytesSize;
    private List<com.uber.jaeger.thriftjava.Span> spanBuffer;
    private int byteBufferSize;
    private AutoExpandingBufferWriteTransport memoryTransport;
    private final TProtocolFactory protocolFactory;
    private final int maxSpanBytes;

    public ThriftSender(TProtocolFactory protocolFactory, int maxPacketSize) {
        this.protocolFactory = protocolFactory;
        if (maxPacketSize == 0) {
            maxPacketSize = 65000;
        }
        this.memoryTransport = new AutoExpandingBufferWriteTransport(maxPacketSize, 2.0);
        this.maxSpanBytes = maxPacketSize - 33;
        this.spanBuffer = new ArrayList<com.uber.jaeger.thriftjava.Span>();
    }

    public abstract void send(Process var1, List<com.uber.jaeger.thriftjava.Span> var2) throws TException;

    @Override
    public int append(Span span) throws SenderException {
        int n;
        com.uber.jaeger.thriftjava.Span thriftSpan;
        int spanSize;
        if (this.process == null) {
            this.process = new Process(span.getTracer().getServiceName());
            this.process.setTags(JaegerThriftSpanConverter.buildTags(span.getTracer().tags()));
            this.processBytesSize = this.getSizeOfSerializedThrift((TBase)this.process);
            this.byteBufferSize += this.processBytesSize;
        }
        if ((spanSize = this.getSizeOfSerializedThrift((TBase)(thriftSpan = JaegerThriftSpanConverter.convertSpan(span)))) > this.maxSpanBytes) {
            throw new SenderException(String.format("ThriftSender received a span that was too large, size = %d, max = %d", spanSize, this.maxSpanBytes), null, 1);
        }
        this.byteBufferSize += spanSize;
        if (this.byteBufferSize <= this.maxSpanBytes) {
            this.spanBuffer.add(thriftSpan);
            if (this.byteBufferSize < this.maxSpanBytes) {
                return 0;
            }
            return this.flush();
        }
        try {
            n = this.flush();
        }
        catch (SenderException e) {
            throw new SenderException(e.getMessage(), e.getCause(), e.getDroppedSpanCount() + 1);
        }
        this.spanBuffer.add(thriftSpan);
        this.byteBufferSize = this.processBytesSize + spanSize;
        return n;
    }

    @Override
    public int flush() throws SenderException {
        if (this.spanBuffer.isEmpty()) {
            return 0;
        }
        int n = this.spanBuffer.size();
        try {
            this.send(this.process, this.spanBuffer);
        }
        catch (TException e) {
            throw new SenderException("Failed to flush spans.", e, n);
        }
        finally {
            this.spanBuffer.clear();
            this.byteBufferSize = this.processBytesSize;
        }
        return n;
    }

    @Override
    public int close() throws SenderException {
        return this.flush();
    }

    int getSizeOfSerializedThrift(TBase thriftBase) throws SenderException {
        this.memoryTransport.reset();
        try {
            thriftBase.write(this.protocolFactory.getProtocol((TTransport)this.memoryTransport));
        }
        catch (TException e) {
            throw new SenderException("ThriftSender failed writing to memory buffer.", e, 1);
        }
        return this.memoryTransport.getPos();
    }

    public String toString() {
        return "ThriftSender(process=" + this.process + ", processBytesSize=" + this.processBytesSize + ", byteBufferSize=" + this.byteBufferSize + ", protocolFactory=" + this.protocolFactory + ", maxSpanBytes=" + this.maxSpanBytes + ")";
    }
}

