/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.twitter.zipkin.thriftjava.Endpoint;
import com.uber.jaeger.LogData;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.Tracer;
import com.uber.jaeger.utils.Utils;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Span
implements io.opentracing.Span {
    private final Tracer tracer;
    private final long start;
    private final String operationName;
    private SpanContext context;
    private Endpoint peer;
    private long duration;
    private Map<String, Object> tags;
    private List<LogData> logs;
    private String localComponent;
    private boolean isClient;
    private boolean isRPC;

    Span(Tracer tracer, String operationName, SpanContext context, long start, Map<String, Object> tags) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.context = context;
        this.start = start;
        this.tags = tags;
    }

    public String getLocalComponent() {
        return this.localComponent;
    }

    public long getStart() {
        return this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        Span span = this;
        synchronized (span) {
            return this.duration;
        }
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getPeer() {
        Span span = this;
        synchronized (span) {
            if (this.peer == null) {
                this.peer = new Endpoint();
            }
        }
        return this.peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        Span span = this;
        synchronized (span) {
            return new HashMap<String, Object>(this.tags);
        }
    }

    public String getOperationName() {
        return this.operationName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogData> getLogs() {
        Span span = this;
        synchronized (span) {
            if (this.logs == null) {
                return null;
            }
            return new ArrayList<LogData>(this.logs);
        }
    }

    public SpanContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public io.opentracing.Span setBaggageItem(String key, String value) {
        Span span = this;
        synchronized (span) {
            this.context = this.context.withBaggageItem(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaggageItem(String key) {
        Span span = this;
        synchronized (span) {
            return this.context.getBaggageItem(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Span span = this;
        synchronized (span) {
            return this.context.contextAsString() + " - " + this.operationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public io.opentracing.SpanContext context() {
        Span span = this;
        synchronized (span) {
            return this.context;
        }
    }

    public void finish() {
        this.finish(Utils.getMicroseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(long finishMicros) {
        Span span = this;
        synchronized (span) {
            this.duration = finishMicros - this.start;
        }
        if (this.context.isSampled()) {
            this.tracer.reportSpan(this);
        }
    }

    public void close() {
        this.finish();
    }

    public Span setTag(String key, String value) {
        return this.setTagAsObject(key, value);
    }

    public Span setTag(String key, boolean value) {
        return this.setTagAsObject(key, value);
    }

    public Span setTag(String key, Number value) {
        return this.setTagAsObject(key, value);
    }

    private boolean handleSpecialTag(String key, Object value) {
        if (key.equals(Tags.COMPONENT.getKey()) && value instanceof String) {
            this.localComponent = (String)value;
            return true;
        }
        if (key.equals(Tags.PEER_HOST_IPV4.getKey()) && value instanceof Integer) {
            this.getPeer().setIpv4((Integer)value);
            return true;
        }
        if (key.equals(Tags.PEER_PORT.getKey()) && value instanceof Number) {
            this.getPeer().setPort(((Number)value).shortValue());
            return true;
        }
        if (key.equals(Tags.PEER_SERVICE.getKey()) && value instanceof String) {
            this.getPeer().setService_name((String)value);
            return true;
        }
        if (key.equals(Tags.SPAN_KIND.getKey()) && value instanceof String) {
            this.isClient = "client".equals(value);
            this.isRPC = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Span setTagAsObject(String key, Object value) {
        Span span = this;
        synchronized (span) {
            if (key.equals(Tags.SAMPLING_PRIORITY.getKey()) && value instanceof Number) {
                int priority = ((Number)value).intValue();
                byte newFlags = priority > 0 ? (byte)(this.context.getFlags() | 1 | 2) : (byte)(this.context.getFlags() & 0xFFFFFFFE);
                this.context = this.context.withFlags(newFlags);
            }
            if (this.context.isSampled() && !this.handleSpecialTag(key, value)) {
                if (this.tags == null) {
                    this.tags = new HashMap<String, Object>();
                }
                this.tags.put(key, value);
            }
        }
        return this;
    }

    public Span log(String message, Object payload) {
        return this.log(Utils.getMicroseconds(), message, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Span log(long instantMicroseconds, String message, Object payload) {
        Span span = this;
        synchronized (span) {
            if (this.context.isSampled()) {
                if (this.logs == null) {
                    this.logs = new ArrayList<LogData>();
                }
                this.logs.add(new LogData(instantMicroseconds, message, payload));
            }
            return this;
        }
    }

    public boolean isRPC() {
        return this.isRPC;
    }

    public boolean isRPCClient() {
        return this.isClient;
    }
}

