/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.LogData;
import com.uber.jaeger.Span;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.Tracer;
import com.uber.jaeger.metrics.InMemoryStatsReporter;
import com.uber.jaeger.reporters.InMemoryReporter;
import com.uber.jaeger.samplers.ConstSampler;
import com.uber.jaeger.utils.Utils;
import io.opentracing.tag.Tags;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Utils.class})
public class SpanTest {
    private Tracer tracer;
    private Span span;
    private InMemoryStatsReporter metricsReporter;
    private SpanContext context;

    @Before
    public void setUp() throws Exception {
        this.metricsReporter = new InMemoryStatsReporter();
        this.tracer = new Tracer.Builder("SamplerTest", new InMemoryReporter(), new ConstSampler(true)).withStatsReporter(this.metricsReporter).build();
        this.span = (Span)this.tracer.buildSpan("some-operation").start();
        Random rand = new Random();
        this.context = new SpanContext(rand.nextLong(), rand.nextLong(), rand.nextLong(), 1);
    }

    @Test
    public void testSpanMetrics() {
        Assert.assertEquals((long)1L, (long)this.metricsReporter.counters.get("jaeger.spans.group=sampling.sampled=y"));
        Assert.assertEquals((long)1L, (long)this.metricsReporter.counters.get("jaeger.spans.group=lifecycle.state=started"));
        Assert.assertEquals((long)1L, (long)this.metricsReporter.counters.get("jaeger.traces.sampled=y.state=started"));
    }

    @Test
    public void testSetAndGetBaggageItem() {
        String expected = "expected";
        String key = "some.BAGGAGE";
        this.span.setBaggageItem(key, expected);
        Assert.assertEquals((Object)expected, (Object)this.span.getBaggageItem(key));
    }

    @Test
    public void testSetBooleanTag() {
        Boolean expected = true;
        String key = "tag.key";
        this.span.setTag(key, expected);
        Assert.assertEquals((Object)expected, (Object)this.span.getTags().get(key));
    }

    @Test
    public void testSetStringTag() {
        String expected = "expected.value";
        String key = "tag.key";
        this.span.setTag(key, expected);
        Assert.assertEquals((Object)expected, (Object)this.span.getTags().get(key));
    }

    @Test
    public void testSetNumberTag() {
        Integer expected = 5;
        String key = "tag.key";
        this.span.setTag(key, expected);
        Assert.assertEquals((Object)expected, (Object)this.span.getTags().get(key));
    }

    @Test
    public void testSpanFinish() {
        Span span = (Span)this.tracer.buildSpan("test-service-name").withStartTimestamp(333L).start();
        PowerMockito.mockStatic(Utils.class, (Class[])new Class[0]);
        BDDMockito.given((Object)Utils.getMicroseconds()).willReturn((Object)999L);
        span.finish();
        InMemoryReporter reporter = (InMemoryReporter)this.tracer.getReporter();
        Assert.assertEquals((long)reporter.getSpans().size(), (long)1L);
        Assert.assertEquals((long)span.getDuration(), (long)666L);
    }

    @Test
    public void testSpanToString() {
        Span span = (Span)this.tracer.buildSpan("test-operation").start();
        SpanContext expectedContext = span.getContext();
        SpanContext actualContext = SpanContext.contextFromString(span.getContext().contextAsString());
        Assert.assertEquals((long)expectedContext.getTraceID(), (long)actualContext.getTraceID());
        Assert.assertEquals((long)expectedContext.getSpanID(), (long)actualContext.getSpanID());
        Assert.assertEquals((long)expectedContext.getParentID(), (long)actualContext.getParentID());
        Assert.assertEquals((long)expectedContext.getFlags(), (long)actualContext.getFlags());
    }

    @Test
    public void testOperationName() {
        String expectedOperation = "leela";
        Span span = (Span)this.tracer.buildSpan(expectedOperation).start();
        Assert.assertEquals((Object)expectedOperation, (Object)span.getOperationName());
    }

    @Test
    public void testLog() {
        long expectedTimestamp = 2222L;
        String expectedLog = "some-log";
        Tracer expectedPayload = this.tracer;
        this.span.log(expectedTimestamp, expectedLog, expectedPayload);
        LogData actualLogData = this.span.getLogs().get(0);
        Assert.assertEquals((long)expectedTimestamp, (long)actualLogData.getTime());
        Assert.assertEquals((Object)expectedLog, (Object)actualLogData.getMessage());
        Assert.assertEquals((Object)expectedPayload, (Object)actualLogData.getPayload());
    }

    @Test
    public void testLogWithTimestamp() {
        long expectedTimestamp = 2222L;
        String expectedLog = "some-log";
        Tracer expectedPayload = this.tracer;
        PowerMockito.mockStatic(Utils.class, (Class[])new Class[0]);
        BDDMockito.given((Object)Utils.getMicroseconds()).willReturn((Object)expectedTimestamp);
        Span span = (Span)this.tracer.buildSpan("test-service-operation").start();
        span.log(expectedLog, expectedPayload);
        LogData actualLogData = span.getLogs().get(0);
        Assert.assertEquals((long)expectedTimestamp, (long)actualLogData.getTime());
        Assert.assertEquals((Object)expectedLog, (Object)actualLogData.getMessage());
        Assert.assertEquals((Object)expectedPayload, (Object)actualLogData.getPayload());
    }

    @Test
    public void testSpanDetectsEndpointTags() {
        int expectedIp = 2130706433;
        short expectedPort = 8080;
        String expectedServiceName = "some-peer-service";
        Span span = (Span)this.tracer.buildSpan("test-service-operation").start();
        Tags.PEER_HOST_IPV4.set((io.opentracing.Span)span, Integer.valueOf(expectedIp));
        Tags.PEER_PORT.set((io.opentracing.Span)span, Short.valueOf(expectedPort));
        Tags.PEER_SERVICE.set((io.opentracing.Span)span, expectedServiceName);
        Assert.assertEquals((long)expectedIp, (long)span.getPeer().getIpv4());
        Assert.assertEquals((long)expectedPort, (long)span.getPeer().getPort());
        Assert.assertEquals((Object)expectedServiceName, (Object)span.getPeer().getService_name());
    }

    @Test
    public void testSpanDetectsLocalComponent() {
        String expectedComponentName = "some-lc-name";
        Span span = (Span)this.tracer.buildSpan("test-service-operation").start();
        Tags.COMPONENT.set((io.opentracing.Span)span, expectedComponentName);
        Assert.assertEquals((Object)expectedComponentName, (Object)span.getLocalComponent());
    }

    @Test
    public void testSpanDetectsIsServer() {
        Span span = (Span)this.tracer.buildSpan("test-service-operation").start();
        Tags.SPAN_KIND.set((io.opentracing.Span)span, "client");
        Assert.assertTrue((boolean)span.isRPCClient());
    }

    @Test
    public void testSpanDetectsSamplingPriorityGreaterThanZero() {
        Span span = (Span)this.tracer.buildSpan("test-service-operation").start();
        Tags.SAMPLING_PRIORITY.set((io.opentracing.Span)span, Short.valueOf((short)1));
        Assert.assertEquals((long)(span.getContext().getFlags() & 1), (long)1L);
        Assert.assertEquals((long)(span.getContext().getFlags() & 2), (long)2L);
    }

    @Test
    public void testSpanDetectsSamplingPriorityLessThanZero() {
        Span span = (Span)this.tracer.buildSpan("test-service-operation").start();
        Assert.assertEquals((long)(span.getContext().getFlags() & 1), (long)1L);
        Tags.SAMPLING_PRIORITY.set((io.opentracing.Span)span, Short.valueOf((short)-1));
        Assert.assertEquals((long)(span.getContext().getFlags() & 1), (long)0L);
    }
}

