/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.SpanContext;
import com.uber.jaeger.exceptions.EmptyTracerStateStringException;
import com.uber.jaeger.exceptions.MalformedTracerStateStringException;
import org.junit.Assert;
import org.junit.Test;

public class TraceContextTest {
    @Test(expected=MalformedTracerStateStringException.class)
    public void testContextFromStringMalformedException() throws EmptyTracerStateStringException, MalformedTracerStateStringException {
        SpanContext.contextFromString("ff:ff:ff");
    }

    @Test(expected=EmptyTracerStateStringException.class)
    public void testContextFromStringEmptyException() throws EmptyTracerStateStringException, MalformedTracerStateStringException {
        SpanContext.contextFromString("");
    }

    @Test
    public void testContextFromString() throws EmptyTracerStateStringException, MalformedTracerStateStringException {
        SpanContext context = SpanContext.contextFromString("ff:dd:cc:4");
        Assert.assertEquals((long)context.getTraceID(), (long)255L);
        Assert.assertEquals((long)context.getSpanID(), (long)221L);
        Assert.assertEquals((long)context.getParentID(), (long)204L);
        Assert.assertEquals((long)context.getFlags(), (long)4L);
    }

    @Test
    public void testToStringFormatsPostitiveFields() {
        long traceID = -9L;
        long spanID = -9L;
        long parentID = -9L;
        byte flags = -127;
        SpanContext context = new SpanContext(traceID, spanID, parentID, flags);
        context.contextAsString().split(":");
        Assert.assertEquals((Object)"fffffffffffffff7:fffffffffffffff7:fffffffffffffff7:81", (Object)context.contextAsString());
        SpanContext contextFromStr = SpanContext.contextFromString(context.contextAsString());
        Assert.assertEquals((long)traceID, (long)contextFromStr.getTraceID());
        Assert.assertEquals((long)spanID, (long)contextFromStr.getSpanID());
        Assert.assertEquals((long)parentID, (long)contextFromStr.getParentID());
        Assert.assertEquals((long)flags, (long)contextFromStr.getFlags());
    }
}

