/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.Span;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.exceptions.UnsupportedFormatException;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.NullStatsReporter;
import com.uber.jaeger.metrics.StatsFactoryImpl;
import com.uber.jaeger.metrics.StatsReporter;
import com.uber.jaeger.propagation.Extractor;
import com.uber.jaeger.propagation.Injector;
import com.uber.jaeger.propagation.TextMapCodec;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.utils.Utils;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class Tracer
implements io.opentracing.Tracer {
    private final Reporter reporter;
    private final Sampler sampler;
    private final PropagationRegistry registry;
    private final String serviceName;
    private final Metrics metrics;
    private int ip;

    private Tracer(String serviceName, Reporter reporter, Sampler sampler, PropagationRegistry registry, Metrics metrics) {
        this.serviceName = serviceName;
        try {
            this.ip = Utils.ipToInt(Inet4Address.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            this.ip = 0;
        }
        this.reporter = reporter;
        this.sampler = sampler;
        this.registry = registry;
        this.metrics = metrics;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getIP() {
        return this.ip;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    void reportSpan(Span span) {
        this.reporter.report(span);
        this.metrics.spansFinished.inc(1L);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new SpanBuilder(operationName);
    }

    public <T> void inject(io.opentracing.SpanContext spanContext, Format<T> format, T carrier) {
        Injector<T> injector = this.registry.getInjector(format);
        if (injector == null) {
            throw new UnsupportedFormatException(format);
        }
        injector.inject((SpanContext)spanContext, carrier);
    }

    public <T> io.opentracing.SpanContext extract(Format<T> format, T carrier) {
        Extractor<T> extractor = this.registry.getExtractor(format);
        if (extractor == null) {
            throw new UnsupportedFormatException(format);
        }
        return extractor.extract(carrier);
    }

    private static class PropagationRegistry {
        private final Map<Format<?>, Injector<?>> injectors = new HashMap();
        private final Map<Format<?>, Extractor<?>> extractors = new HashMap();

        private PropagationRegistry() {
        }

        <T> Injector<T> getInjector(Format<T> format) {
            return this.injectors.get(format);
        }

        <T> Extractor<T> getExtractor(Format<T> format) {
            return this.extractors.get(format);
        }

        public <T> void register(Format<T> format, Injector<T> injector) {
            this.injectors.put(format, injector);
        }

        public <T> void register(Format<T> format, Extractor<T> extractor) {
            this.extractors.put(format, extractor);
        }
    }

    public static final class Builder {
        private final Sampler sampler;
        private final Reporter reporter;
        private final PropagationRegistry registry = new PropagationRegistry();
        private Metrics metrics;
        private String serviceName;

        public Builder(String serviceName, Reporter reporter, Sampler sampler) {
            this.serviceName = serviceName;
            this.reporter = reporter;
            this.sampler = sampler;
            this.metrics = new Metrics(new StatsFactoryImpl(new NullStatsReporter()));
            TextMapCodec textMapCodec = new TextMapCodec(false);
            this.registerInjector(Format.Builtin.TEXT_MAP, textMapCodec);
            this.registerExtractor(Format.Builtin.TEXT_MAP, textMapCodec);
            TextMapCodec httpCodec = new TextMapCodec(true);
            this.registerInjector(Format.Builtin.HTTP_HEADERS, httpCodec);
            this.registerExtractor(Format.Builtin.HTTP_HEADERS, httpCodec);
        }

        public <T> Builder registerInjector(Format<T> format, Injector<T> injector) {
            this.registry.register(format, injector);
            return this;
        }

        public <T> Builder registerExtractor(Format<T> format, Extractor<T> extractor) {
            this.registry.register(format, extractor);
            return this;
        }

        public Builder withStatsReporter(StatsReporter statsReporter) {
            this.metrics = new Metrics(new StatsFactoryImpl(statsReporter));
            return this;
        }

        Builder withMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Tracer build() {
            return new Tracer(this.serviceName, this.reporter, this.sampler, this.registry, this.metrics);
        }
    }

    private class SpanBuilder
    implements Tracer.SpanBuilder {
        private String operationName = null;
        private long start;
        private SpanContext parent;
        private final Map<String, Object> tags = new HashMap<String, Object>();

        SpanBuilder(String operationName) {
            this.operationName = operationName;
        }

        public Tracer.SpanBuilder asChildOf(io.opentracing.SpanContext parent) {
            return this.addReference("child_of", parent);
        }

        public Tracer.SpanBuilder asChildOf(io.opentracing.Span parent) {
            return this.addReference("child_of", parent.context());
        }

        public Tracer.SpanBuilder addReference(String referenceType, io.opentracing.SpanContext referencedContext) {
            if (this.parent == null && (referenceType == "child_of" || referenceType == "follows_from")) {
                this.parent = (SpanContext)referencedContext;
            }
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, boolean value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withTag(String key, Number value) {
            this.tags.put(key, value);
            return this;
        }

        public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
            this.start = microseconds;
            return this;
        }

        private SpanContext createNewContext() {
            long id = Utils.uniqueID();
            byte flags = 0;
            if (Tracer.this.sampler.isSampled(id)) {
                flags = (byte)(flags | 1);
                ((Tracer)Tracer.this).metrics.traceStartedSampled.inc(1L);
            } else {
                ((Tracer)Tracer.this).metrics.traceStartedNotSampled.inc(1L);
            }
            return new SpanContext(id, id, 0L, flags);
        }

        private SpanContext createChildContext() {
            if (this.tags.get(Tags.SPAN_KIND.getKey()) == "server") {
                if (this.parent.isSampled()) {
                    ((Tracer)Tracer.this).metrics.tracesJoinedSampled.inc(1L);
                } else {
                    ((Tracer)Tracer.this).metrics.tracesJoinedNotSampled.inc(1L);
                }
                return this.parent;
            }
            return new SpanContext(this.parent.getTraceID(), Utils.uniqueID(), this.parent.getSpanID(), this.parent.getFlags(), this.parent.baggage());
        }

        public io.opentracing.Span start() {
            SpanContext context;
            SpanContext spanContext = context = this.parent == null ? this.createNewContext() : this.createChildContext();
            if (this.start == 0L) {
                this.start = Utils.getMicroseconds();
            }
            Span span = new Span(Tracer.this, this.operationName, context, this.start, this.tags);
            if (context.isSampled()) {
                ((Tracer)Tracer.this).metrics.spansSampled.inc(1L);
            } else {
                ((Tracer)Tracer.this).metrics.spansNotSampled.inc(1L);
            }
            ((Tracer)Tracer.this).metrics.spansStarted.inc(1L);
            return span;
        }
    }
}

