/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.Span;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.Tracer;
import com.uber.jaeger.metrics.InMemoryStatsReporter;
import com.uber.jaeger.propagation.Injector;
import com.uber.jaeger.reporters.InMemoryReporter;
import com.uber.jaeger.samplers.ConstSampler;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TracerTest {
    Tracer tracer;
    InMemoryStatsReporter metricsReporter;

    @Before
    public void setUp() throws Exception {
        this.metricsReporter = new InMemoryStatsReporter();
        this.tracer = new Tracer.Builder("TracerTestService", new InMemoryReporter(), new ConstSampler(true)).withStatsReporter(this.metricsReporter).build();
    }

    @Test
    public void testBuildSpan() {
        String expectedOperation = "fry";
        Span span = (Span)this.tracer.buildSpan(expectedOperation).start();
        Assert.assertEquals((Object)expectedOperation, (Object)span.getOperationName());
    }

    @Test
    public void testTracerMetrics() {
        String expectedOperation = "fry";
        this.tracer.buildSpan(expectedOperation).start();
        Assert.assertEquals((long)1L, (long)this.metricsReporter.counters.get("jaeger.spans.group=sampling.sampled=y"));
        Assert.assertEquals((long)1L, (long)this.metricsReporter.counters.get("jaeger.spans.group=lifecycle.state=started"));
        Assert.assertEquals((long)1L, (long)this.metricsReporter.counters.get("jaeger.traces.sampled=y.state=started"));
    }

    @Test
    public void testRegisterInjector() {
        Injector injector = (Injector)Mockito.mock(Injector.class);
        Tracer tracer = new Tracer.Builder("TracerTestService", new InMemoryReporter(), new ConstSampler(true)).withStatsReporter(this.metricsReporter).registerInjector(Format.Builtin.TEXT_MAP, injector).build();
        Span span = (Span)tracer.buildSpan("leela").start();
        TextMap carrier = (TextMap)Mockito.mock(TextMap.class);
        tracer.inject(span.context(), Format.Builtin.TEXT_MAP, carrier);
        ((Injector)Mockito.verify((Object)injector)).inject((SpanContext)Matchers.any(SpanContext.class), Matchers.any(TextMap.class));
    }
}

