/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.exceptions.EmptyIPException;
import com.uber.jaeger.exceptions.NotFourOctetsException;
import com.uber.jaeger.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    @Test
    public void testNormalizeBaggageKey() {
        String expectedKey = "test-key";
        String actualKey = Utils.normalizeBaggageKey("TEST_KEY");
        Assert.assertEquals((Object)expectedKey, (Object)actualKey);
    }

    @Test(expected=NotFourOctetsException.class)
    public void testIPToInt32NotFourOctets() {
        Utils.ipToInt(":19");
    }

    @Test(expected=EmptyIPException.class)
    public void testIPToInt32EmptyIPException() {
        Utils.ipToInt("");
    }

    @Test
    public void testIPToInt32() {
        int expectedIP = 2130706433;
        int actualIP = Utils.ipToInt("127.0.0.1");
        Assert.assertEquals((long)expectedIP, (long)actualIP);
    }
}

