/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.metrics;

import com.uber.jaeger.metrics.InMemoryStatsReporter;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.StatsFactoryImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricsTest {
    InMemoryStatsReporter metricsReporter;
    Metrics metrics;

    @Before
    public void setUp() throws Exception {
        this.metricsReporter = new InMemoryStatsReporter();
        this.metrics = new Metrics(new StatsFactoryImpl(this.metricsReporter));
    }

    @After
    public void tearDown() {
        this.metricsReporter.reset();
    }

    @Test
    public void testCounterWithoutExplicitTags() throws Exception {
        this.metrics.tracesJoinedSampled.inc(1L);
        Object[] metricNames = this.metricsReporter.counters.keySet().toArray();
        String metricName = (String)metricNames[0];
        long expectedAmount = this.metricsReporter.counters.get(metricName);
        Assert.assertEquals((long)metricNames.length, (long)1L);
        Assert.assertEquals((long)expectedAmount, (long)1L);
        Assert.assertEquals((Object)"jaeger.traces.sampled=y.state=joined", (Object)metricName);
    }

    @Test
    public void testCounterWithExplicitTags() throws Exception {
        this.metrics.tracesJoinedSampled.inc(1L);
        Object[] metricNames = this.metricsReporter.counters.keySet().toArray();
        String metricName = (String)metricNames[0];
        long expectedAmount = this.metricsReporter.counters.get(metricName);
        Assert.assertEquals((long)metricNames.length, (long)1L);
        Assert.assertEquals((long)expectedAmount, (long)1L);
        Assert.assertEquals((Object)"jaeger.traces.sampled=y.state=joined", (Object)metricName);
    }

    @Test
    public void testGaugeWithoutExplicitTags() {
        this.metrics.reporterQueueLength.update(1L);
        Object[] metricNames = this.metricsReporter.gauges.keySet().toArray();
        String metricName = (String)metricNames[0];
        long expectedAmount = this.metricsReporter.gauges.get(metricName);
        Assert.assertEquals((long)metricNames.length, (long)1L);
        Assert.assertEquals((double)1.0, (double)expectedAmount, (double)1.0E-5);
        Assert.assertEquals((Object)"jaeger.reporter-queue", (Object)metricName);
    }
}

