/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.propagation;

import com.uber.jaeger.SpanContext;
import com.uber.jaeger.propagation.Extractor;
import com.uber.jaeger.propagation.Injector;
import com.uber.jaeger.propagation.PrefixedKeys;
import io.opentracing.propagation.TextMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class TextMapCodec
implements Injector<TextMap>,
Extractor<TextMap> {
    private static final String SPAN_CONTEXT_KEY = "uber-trace-id";
    private static final String BAGGAGE_KEY_PREFIX = "uberctx-";
    private static final PrefixedKeys keys = new PrefixedKeys();
    private final String contextKey = "uber-trace-id";
    private final String baggagePrefix = "uberctx-";
    private final boolean urlEncoding;

    public TextMapCodec(boolean urlEncoding) {
        this.urlEncoding = urlEncoding;
    }

    @Override
    public void inject(SpanContext spanContext, TextMap carrier) {
        carrier.put(SPAN_CONTEXT_KEY, this.encodedValue(spanContext.contextAsString()));
        for (Map.Entry<String, String> entry : spanContext.baggageItems()) {
            carrier.put(keys.prefixedKey(entry.getKey(), BAGGAGE_KEY_PREFIX), this.encodedValue(entry.getValue()));
        }
    }

    @Override
    public SpanContext extract(TextMap carrier) {
        SpanContext context = null;
        HashMap<String, String> baggage = null;
        for (Map.Entry entry : carrier) {
            String key = ((String)entry.getKey()).toLowerCase();
            if (key.equals(SPAN_CONTEXT_KEY)) {
                context = SpanContext.contextFromString(this.decodedValue((String)entry.getValue()));
                continue;
            }
            if (!key.startsWith(BAGGAGE_KEY_PREFIX)) continue;
            if (baggage == null) {
                baggage = new HashMap<String, String>();
            }
            baggage.put(keys.unprefixedKey(key, BAGGAGE_KEY_PREFIX), this.decodedValue((String)entry.getValue()));
        }
        if (context == null) {
            return null;
        }
        if (baggage == null) {
            return context;
        }
        return context.withBaggage(baggage);
    }

    private String encodedValue(String value) {
        if (!this.urlEncoding) {
            return value;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private String decodedValue(String value) {
        if (!this.urlEncoding) {
            return value;
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }
}

