/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.reporters;

import com.uber.jaeger.Span;
import com.uber.jaeger.Tracer;
import com.uber.jaeger.metrics.InMemoryStatsReporter;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.metrics.StatsFactoryImpl;
import com.uber.jaeger.reporters.RemoteReporter;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.samplers.ConstSampler;
import com.uber.jaeger.senders.InMemorySender;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoteReporterTest {
    private Reporter reporter;
    private Tracer tracer;
    private InMemorySender sender;
    private final int flushInterval = 1000;
    private final int maxQueueSize = 500;
    private Metrics metrics;
    InMemoryStatsReporter metricsReporter;

    @Before
    public void setUp() throws Exception {
        this.metricsReporter = new InMemoryStatsReporter();
        this.metrics = new Metrics(new StatsFactoryImpl(this.metricsReporter));
        this.sender = new InMemorySender();
        this.reporter = new RemoteReporter(this.sender, 1000, 500, this.metrics);
        this.tracer = new Tracer.Builder("test-remote-reporter", this.reporter, new ConstSampler(true)).withStatsReporter(this.metricsReporter).build();
    }

    @Test
    public void testRemoteReporterReport() throws Exception {
        Span span = (Span)this.tracer.buildSpan("raza").start();
        this.reporter.report(span);
        Thread.sleep(5L);
        List<com.twitter.zipkin.thriftjava.Span> received = this.sender.getReceived();
        Assert.assertEquals((long)received.size(), (long)1L);
    }

    @Test
    public void testRemoteReporterFlushesOnClose() throws Exception {
        int numberOfSpans = 100;
        for (int i = 0; i < numberOfSpans; ++i) {
            Span span = (Span)this.tracer.buildSpan("raza").start();
            this.reporter.report(span);
        }
        this.reporter.close();
        Assert.assertEquals((long)this.sender.getAppended().size(), (long)0L);
        Assert.assertEquals((long)this.sender.getFlushed().size(), (long)numberOfSpans);
        Assert.assertEquals((long)100L, (long)this.metricsReporter.counters.get("jaeger.spans.group=sampling.sampled=y"));
        Assert.assertEquals((long)100L, (long)this.metricsReporter.counters.get("jaeger.spans.group=lifecycle.state=started"));
        Assert.assertEquals((long)100L, (long)this.metricsReporter.counters.get("jaeger.reporter-spans.state=success"));
        Assert.assertEquals((long)100L, (long)this.metricsReporter.counters.get("jaeger.traces.sampled=y.state=started"));
    }
}

