/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.reporters.protocols;

import com.twitter.zipkin.thriftjava.Span;
import com.uber.jaeger.agent.thrift.Agent;
import com.uber.jaeger.reporters.protocols.InMemorySpanServerHandler;
import com.uber.jaeger.reporters.protocols.TUDPServerTransport;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TSimpleServer;
import org.apache.thrift.transport.TServerTransport;

public class TestTServer
implements Runnable {
    TServer server;
    InMemorySpanServerHandler handler = new InMemorySpanServerHandler();
    TUDPServerTransport transport;

    public TestTServer(int port) throws SocketException, UnknownHostException {
        this.transport = new TUDPServerTransport(port);
        this.server = new TSimpleServer(((TServer.Args)new TServer.Args((TServerTransport)this.transport).protocolFactory((TProtocolFactory)new TCompactProtocol.Factory())).processor(new Agent.Processor<InMemorySpanServerHandler>(this.handler)));
    }

    public int getPort() {
        return this.transport.getPort();
    }

    @Override
    public void run() {
        this.server.serve();
    }

    public void close() {
        this.server.stop();
    }

    public List<Span> getSpans(int expectedSpans, int timeout) throws Exception {
        ArrayList<Span> spans = new ArrayList<Span>();
        long expire = (long)timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expire) {
            List<Span> receivedSpans = this.handler.getSpans();
            if (receivedSpans != null) {
                spans.addAll(receivedSpans);
            }
            if (spans.size() >= expectedSpans) {
                return spans;
            }
            Thread.sleep(1L);
        }
        return spans;
    }
}

