/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.reporters.protocols;

import com.twitter.zipkin.thriftjava.Annotation;
import com.uber.jaeger.Span;
import com.uber.jaeger.Tracer;
import com.uber.jaeger.reporters.InMemoryReporter;
import com.uber.jaeger.reporters.protocols.ThriftSpanConverter;
import com.uber.jaeger.samplers.ConstSampler;
import io.opentracing.tag.Tags;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ThriftSpanConverterTest {
    Tracer tracer;

    @Before
    public void setUp() {
        this.tracer = new Tracer.Builder("test-service-name", new InMemoryReporter(), new ConstSampler(true)).build();
    }

    @Test
    public void testSpanKindServerCreatesAnnotations() {
        Span span = (Span)this.tracer.buildSpan("operation-name").start();
        Tags.SPAN_KIND.set((io.opentracing.Span)span, "server");
        com.twitter.zipkin.thriftjava.Span zipkinSpan = ThriftSpanConverter.convertSpan(span);
        List<Annotation> annotations = zipkinSpan.getAnnotations();
        boolean serverReceiveFound = false;
        boolean serverSendFound = false;
        for (Annotation anno : annotations) {
            if (anno.getValue().equals("sr")) {
                serverReceiveFound = true;
            }
            if (!anno.getValue().equals("ss")) continue;
            serverSendFound = true;
        }
        TestCase.assertTrue((boolean)serverReceiveFound);
        TestCase.assertTrue((boolean)serverSendFound);
    }

    @Test
    public void testSpanKindClientCreatesAnnotations() {
        Span span = (Span)this.tracer.buildSpan("operation-name").start();
        Tags.SPAN_KIND.set((io.opentracing.Span)span, "client");
        com.twitter.zipkin.thriftjava.Span zipkinSpan = ThriftSpanConverter.convertSpan(span);
        List<Annotation> annotations = zipkinSpan.getAnnotations();
        boolean clientReceiveFound = false;
        boolean clientSendFound = false;
        for (Annotation anno : annotations) {
            if (anno.getValue().equals("cr")) {
                clientReceiveFound = true;
            }
            if (!anno.getValue().equals("cs")) continue;
            clientSendFound = true;
        }
        TestCase.assertTrue((boolean)clientReceiveFound);
        TestCase.assertTrue((boolean)clientSendFound);
    }

    @Test
    public void testExpectdLocalComponentNameUsed() {
        String expectedCompnentName = "local-name";
        Span span = (Span)this.tracer.buildSpan("operation-name").start();
        Tags.COMPONENT.set((io.opentracing.Span)span, expectedCompnentName);
        com.twitter.zipkin.thriftjava.Span zipkinSpan = ThriftSpanConverter.convertSpan(span);
        String actualComponent = new String(zipkinSpan.getBinary_annotations().get(0).getValue());
        Assert.assertEquals((Object)expectedCompnentName, (Object)actualComponent);
    }
}

