/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.uber.jaeger.samplers.Sampler;

public class ProbabilisticSampler
implements Sampler {
    private final long positiveSamplingBoundary;
    private final long negativeSamplingBoundary;
    private final double samplingRate;

    public ProbabilisticSampler(double samplingRate) {
        if (samplingRate < 0.0 || samplingRate > 1.0) {
            throw new IllegalArgumentException("The sampling rate must be greater than 0.0 and less than 1.0");
        }
        this.samplingRate = samplingRate;
        this.positiveSamplingBoundary = (long)(9.223372036854776E18 * samplingRate);
        this.negativeSamplingBoundary = (long)(-9.223372036854776E18 * samplingRate);
    }

    @Override
    public boolean isSampled(long id) {
        if (id > 0L) {
            return id <= this.positiveSamplingBoundary;
        }
        return id >= this.negativeSamplingBoundary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ProbabilisticSampler) {
            return this.samplingRate == ((ProbabilisticSampler)other).samplingRate;
        }
        return false;
    }

    @Override
    public void close() {
    }
}

