/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.uber.jaeger.samplers.ProbabilisticSampler;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

public class ProbabilisticSamplerTest {
    @Test
    public void testSamplingBoundariesPositive() {
        double samplingRate = 0.5;
        long halfwayBoundary = 0x3FFFFFFFFFFFFFFFL;
        ProbabilisticSampler sampler = new ProbabilisticSampler(samplingRate);
        Assert.assertTrue((boolean)sampler.isSampled(halfwayBoundary));
        TestCase.assertFalse((boolean)sampler.isSampled(halfwayBoundary + 2L));
    }

    @Test
    public void testSamplingBoundariesNegative() {
        double samplingRate = 0.5;
        long halfwayBoundary = -4611686018427387904L;
        ProbabilisticSampler sampler = new ProbabilisticSampler(samplingRate);
        Assert.assertTrue((boolean)sampler.isSampled(halfwayBoundary));
        TestCase.assertFalse((boolean)sampler.isSampled(halfwayBoundary - 1L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSamplerThrowsInvalidSamplingRangeExceptionUnder() {
        ProbabilisticSampler sampler = new ProbabilisticSampler(-0.1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSamplerThrowsInvalidSamplingRangeExceptionOver() {
        ProbabilisticSampler sampler = new ProbabilisticSampler(1.1);
    }
}

