/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.utils.RateLimiter;

public class RateLimitingSampler
implements Sampler {
    private final RateLimiter rateLimiter;
    private final int maxTracesPerSecond;

    public RateLimitingSampler(int maxTracesPerSecond) {
        this.maxTracesPerSecond = maxTracesPerSecond;
        this.rateLimiter = new RateLimiter(maxTracesPerSecond);
    }

    @Override
    public boolean isSampled(long id) {
        return this.rateLimiter.checkCredit(1.0);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RateLimitingSampler) {
            return this.maxTracesPerSecond == ((RateLimitingSampler)other).maxTracesPerSecond;
        }
        return false;
    }

    @Override
    public void close() {
    }
}

