/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.uber.jaeger.metrics.InMemoryStatsReporter;
import com.uber.jaeger.metrics.Metrics;
import com.uber.jaeger.samplers.ConstSampler;
import com.uber.jaeger.samplers.HTTPSamplingManager;
import com.uber.jaeger.samplers.MockAgent;
import com.uber.jaeger.samplers.ProbabilisticSampler;
import com.uber.jaeger.samplers.RateLimitingSampler;
import com.uber.jaeger.samplers.RemoteControlledSampler;
import com.uber.jaeger.samplers.Sampler;
import com.uber.jaeger.thrift.sampling_manager.SamplingStrategyResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RemoteControlledSamplerTest {
    MockAgent agent;
    Metrics metrics;

    @Before
    public void setUp() throws Exception {
        this.agent = new MockAgent();
        this.agent.start();
        this.metrics = Metrics.fromStatsReporter(new InMemoryStatsReporter());
    }

    @After
    public void tearDown() {
        this.agent.stop();
    }

    @Test
    public void testGetProbabilisticRemoteSamplingStrategy() throws Exception {
        double expectedSamplingRate = 0.001;
        double delta = expectedSamplingRate / 100.0;
        HTTPSamplingManager manager = new HTTPSamplingManager("localhost:" + this.agent.getPort());
        SamplingStrategyResponse response = manager.getSamplingStrategy("clairvoyant");
        Assert.assertEquals((double)response.getProbabilisticSampling().getSamplingRate(), (double)expectedSamplingRate, (double)delta);
    }

    @Test
    public void testGetRateLimitingRemoteSamplingStrategy() throws Exception {
        int expectedMaxTracesPerSecond = 8;
        HTTPSamplingManager manager = new HTTPSamplingManager("localhost:" + this.agent.getPort());
        SamplingStrategyResponse response = manager.getSamplingStrategy("jaeger");
        Assert.assertEquals((long)response.getRateLimitingSampling().getMaxTracesPerSecond(), (long)expectedMaxTracesPerSecond);
    }

    private void testEqualsAgainstSamplers(Sampler trueSampler, Sampler falseSampler) throws Exception {
        HTTPSamplingManager manager = (HTTPSamplingManager)Mockito.mock(HTTPSamplingManager.class);
        SamplingStrategyResponse response = (SamplingStrategyResponse)Mockito.mock(SamplingStrategyResponse.class);
        Mockito.when((Object)response.isSetProbabilisticSampling()).thenReturn((Object)false);
        Mockito.when((Object)response.isSetRateLimitingSampling()).thenReturn((Object)false);
        Mockito.when((Object)manager.getSamplingStrategy("jaeger")).thenReturn((Object)response);
        RemoteControlledSampler sampler = new RemoteControlledSampler("jaeger", manager, trueSampler, this.metrics);
        RemoteControlledSampler otherSampler = new RemoteControlledSampler("jaeger", manager, trueSampler, this.metrics);
        Assert.assertTrue((boolean)sampler.equals(otherSampler));
        otherSampler = new RemoteControlledSampler("jaeger", manager, falseSampler, this.metrics);
        Assert.assertFalse((boolean)sampler.equals(otherSampler));
    }

    @Test
    public void testEquals() throws Exception {
        this.testEqualsAgainstSamplers(new ConstSampler(true), new ConstSampler(false));
        this.testEqualsAgainstSamplers(new ProbabilisticSampler(0.1), new ProbabilisticSampler(0.01));
        this.testEqualsAgainstSamplers(new RateLimitingSampler(4), new RateLimitingSampler(5));
    }
}

