/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.senders;

import com.uber.jaeger.Span;
import com.uber.jaeger.SpanContext;
import com.uber.jaeger.Tracer;
import com.uber.jaeger.agent.thrift.Agent;
import com.uber.jaeger.exceptions.SenderException;
import com.uber.jaeger.metrics.InMemoryStatsReporter;
import com.uber.jaeger.reporters.InMemoryReporter;
import com.uber.jaeger.reporters.Reporter;
import com.uber.jaeger.reporters.protocols.TestTServer;
import com.uber.jaeger.reporters.protocols.ThriftSpanConverter;
import com.uber.jaeger.samplers.ConstSampler;
import com.uber.jaeger.senders.UDPSender;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import org.apache.thrift.transport.TTransport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UDPSenderTest {
    final String destHost = "localhost";
    int destPort;
    int localPort = 0;
    final int maxPacketSize = 1000;
    Tracer tracer;
    Reporter reporter;
    UDPSender sender;
    TestTServer server;
    ThriftSpanConverter converter;

    private TestTServer startServer() throws Exception {
        TestTServer server = new TestTServer(this.localPort);
        this.destPort = server.getPort();
        Thread t = new Thread(server);
        t.start();
        Thread.sleep(5L);
        return server;
    }

    @Before
    public void setUp() throws Exception {
        this.server = this.startServer();
        this.reporter = new InMemoryReporter();
        this.tracer = new Tracer.Builder("test-sender", this.reporter, new ConstSampler(true)).withStatsReporter(new InMemoryStatsReporter()).build();
        this.sender = new UDPSender("localhost", this.destPort, 1000);
        this.converter = new ThriftSpanConverter();
    }

    @After
    public void tearDown() throws Exception {
        this.server.close();
        this.sender.close();
        this.reporter.close();
    }

    @Test(expected=SenderException.class)
    public void testAppendSpanTooLarge() throws Exception {
        Span jaegerSpan = (Span)this.tracer.buildSpan("raza").start();
        String msg = "";
        for (int i = 0; i < 1001; ++i) {
            msg = msg + ".";
        }
        jaegerSpan.log(msg, new Object());
        com.twitter.zipkin.thriftjava.Span span = ThriftSpanConverter.convertSpan(jaegerSpan);
        try {
            this.sender.append(span);
        }
        catch (SenderException e) {
            Assert.assertEquals((long)e.getDroppedSpanCount(), (long)1L);
            throw e;
        }
    }

    @Test
    public void testAppend() throws Exception {
        AutoExpandingBufferWriteTransport memoryTransport = new AutoExpandingBufferWriteTransport(1000, 2.0);
        com.twitter.zipkin.thriftjava.Span span = ThriftSpanConverter.convertSpan((Span)this.tracer.buildSpan("raza").start());
        span.write((TProtocol)new TCompactProtocol((TTransport)memoryTransport));
        int spanSize = memoryTransport.getPos();
        int expectedNumSpans = 11;
        int maxPacketSize = spanSize * expectedNumSpans + 22;
        this.sender = new UDPSender("localhost", this.destPort, maxPacketSize);
        for (int maxPacketSizeLeft = maxPacketSize - 22; spanSize < maxPacketSizeLeft; maxPacketSizeLeft -= spanSize) {
            this.sender.append(span);
        }
        int result = this.sender.append(span);
        Assert.assertEquals((long)expectedNumSpans, (long)result);
    }

    @Test
    public void testFlushSendsSpan() throws Exception {
        int timeout = 50;
        int expectedNumSpans = 1;
        Span expectedSpan = (Span)this.tracer.buildSpan("raza").start();
        com.twitter.zipkin.thriftjava.Span span = ThriftSpanConverter.convertSpan(expectedSpan);
        int appendNum = this.sender.append(span);
        int flushNum = this.sender.flush();
        Assert.assertEquals((long)appendNum, (long)0L);
        Assert.assertEquals((long)flushNum, (long)1L);
        List<com.twitter.zipkin.thriftjava.Span> spans = this.server.getSpans(expectedNumSpans, timeout);
        Assert.assertEquals((long)spans.size(), (long)expectedNumSpans);
        com.twitter.zipkin.thriftjava.Span actualSpan = spans.get(0);
        SpanContext context = expectedSpan.getContext();
        Assert.assertEquals((long)context.getTraceID(), (long)actualSpan.getTrace_id());
        Assert.assertEquals((long)context.getSpanID(), (long)actualSpan.getId());
        Assert.assertEquals((long)context.getParentID(), (long)actualSpan.getParent_id());
        Assert.assertEquals((Object)expectedSpan.getOperationName(), (Object)actualSpan.getName());
    }

    @Test
    public void testEmitZipkinBatchOverhead() throws Exception {
        int a = this.calculateZipkinBatchOverheadDifference(1);
        int b = this.calculateZipkinBatchOverheadDifference(2);
        Assert.assertEquals((long)a, (long)b);
        Assert.assertEquals((long)b, (long)22L);
    }

    private int calculateZipkinBatchOverheadDifference(int numberOfSpans) throws Exception {
        AutoExpandingBufferWriteTransport memoryTransport = new AutoExpandingBufferWriteTransport(1000, 2.0);
        Agent.Client memoryClient = new Agent.Client((TProtocol)new TCompactProtocol((TTransport)memoryTransport));
        Span jaegerSpan = (Span)this.tracer.buildSpan("raza").start();
        com.twitter.zipkin.thriftjava.Span span = ThriftSpanConverter.convertSpan(jaegerSpan);
        ArrayList<com.twitter.zipkin.thriftjava.Span> spans = new ArrayList<com.twitter.zipkin.thriftjava.Span>();
        for (int i = 0; i < numberOfSpans; ++i) {
            spans.add(span);
        }
        memoryClient.emitZipkinBatch(spans);
        int emitZipkinBatchOverheadMultipleSpans = memoryTransport.getPos();
        memoryTransport.reset();
        for (int j = 0; j < numberOfSpans; ++j) {
            span.write((TProtocol)new TCompactProtocol((TTransport)memoryTransport));
        }
        int writeZipkinBatchOverheadMultipleSpans = memoryTransport.getPos();
        return emitZipkinBatchOverheadMultipleSpans - writeZipkinBatchOverheadMultipleSpans;
    }
}

